/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.AdjacencyProperties;
import org.neo4j.gds.api.ImmutableProperties;
import org.neo4j.gds.api.ImmutableRelationships;
import org.neo4j.gds.api.ImmutableTopology;

@ValueClass
public interface Relationships {
    public Topology topology();

    public Optional<Properties> properties();

    public static Relationships of(long relationshipCount, Orientation orientation, boolean isMultiGraph, AdjacencyList adjacencyList) {
        return Relationships.of(relationshipCount, orientation, isMultiGraph, adjacencyList, null, Double.NaN);
    }

    public static Relationships of(long relationshipCount, Orientation orientation, boolean isMultiGraph, AdjacencyList adjacencyList, @Nullable AdjacencyProperties adjacencyProperties, double defaultPropertyValue) {
        Topology topology = ImmutableTopology.of(adjacencyList, relationshipCount, orientation, isMultiGraph);
        Optional maybePropertyCSR = adjacencyProperties != null ? Optional.of(ImmutableProperties.of(adjacencyProperties, relationshipCount, orientation, isMultiGraph, defaultPropertyValue)) : Optional.empty();
        return ImmutableRelationships.of(topology, maybePropertyCSR);
    }

    @ValueClass
    public static interface Properties {
        public AdjacencyProperties propertiesList();

        public long elementCount();

        public Orientation orientation();

        public boolean isMultiGraph();

        public double defaultPropertyValue();
    }

    @ValueClass
    public static interface Topology {
        public static final Topology EMPTY = new Topology(){

            @Override
            public AdjacencyList adjacencyList() {
                return AdjacencyList.EMPTY;
            }

            @Override
            public long elementCount() {
                return 0L;
            }

            @Override
            public Orientation orientation() {
                return Orientation.NATURAL;
            }

            @Override
            public boolean isMultiGraph() {
                return false;
            }
        };

        public AdjacencyList adjacencyList();

        public long elementCount();

        public Orientation orientation();

        public boolean isMultiGraph();
    }
}

