/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.immutables.builder.Builder;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.ImmutableRelationshipPropertyStore;
import org.neo4j.gds.api.RelationshipProperty;

@ValueClass
public interface RelationshipPropertyStore {
    public Map<String, RelationshipProperty> relationshipProperties();

    default public RelationshipProperty get(String propertyKey) {
        return this.relationshipProperties().get(propertyKey);
    }

    default public boolean isEmpty() {
        return this.relationshipProperties().isEmpty();
    }

    default public Set<String> keySet() {
        return this.relationshipProperties().keySet();
    }

    default public Collection<RelationshipProperty> values() {
        return this.relationshipProperties().values();
    }

    default public boolean containsKey(String propertyKey) {
        return this.relationshipProperties().containsKey(propertyKey);
    }

    public static RelationshipPropertyStore empty() {
        return ImmutableRelationshipPropertyStore.of(Collections.emptyMap());
    }

    public static Builder builder() {
        return new Builder().relationshipProperties(Collections.emptyMap());
    }

    @Builder.AccessibleFields
    public static final class Builder
    extends ImmutableRelationshipPropertyStore.Builder {
        public Builder putIfAbsent(String propertyKey, RelationshipProperty relationshipProperty) {
            this.relationshipProperties.putIfAbsent(propertyKey, relationshipProperty);
            return this;
        }
    }
}

