/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.ImmutableRelationshipProperty;
import org.neo4j.gds.api.PropertyState;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.api.ValueTypes;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.schema.RelationshipPropertySchema;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.values.storable.NumberType;

@ValueClass
public interface RelationshipProperty {
    public Relationships.Properties values();

    public RelationshipPropertySchema propertySchema();

    @Configuration.Ignore
    default public String key() {
        return this.propertySchema().key();
    }

    @Configuration.Ignore
    default public ValueType valueType() {
        return this.propertySchema().valueType();
    }

    @Configuration.Ignore
    default public DefaultValue defaultValue() {
        return this.propertySchema().defaultValue();
    }

    @Configuration.Ignore
    default public PropertyState propertyState() {
        return this.propertySchema().state();
    }

    @Configuration.Ignore
    default public Aggregation aggregation() {
        return this.propertySchema().aggregation();
    }

    public static RelationshipProperty of(String key, NumberType type, PropertyState state, Relationships.Properties values, DefaultValue defaultValue, Aggregation aggregation) {
        return ImmutableRelationshipProperty.of(values, RelationshipPropertySchema.of((String)key, (ValueType)ValueTypes.fromNumberType(type), (DefaultValue)defaultValue, (PropertyState)state, (Aggregation)aggregation));
    }
}

