/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.ImmutableRelationshipCursor;
import org.neo4j.gds.api.RelationshipCursor;

@ParametersAreNonnullByDefault
@Generated(from="RelationshipCursor", generator="Modifiables")
@SuppressFBWarnings
@NotThreadSafe
public final class ModifiableRelationshipCursor
implements RelationshipCursor {
    private static final long INIT_BIT_SOURCE_ID = 1L;
    private static final long INIT_BIT_TARGET_ID = 2L;
    private static final long INIT_BIT_PROPERTY = 4L;
    private long initBits = 7L;
    private long sourceId;
    private long targetId;
    private double property;

    private ModifiableRelationshipCursor() {
    }

    public static ModifiableRelationshipCursor create(long sourceId, long targetId, double property) {
        return new ModifiableRelationshipCursor().setSourceId(sourceId).setTargetId(targetId).setProperty(property);
    }

    public static ModifiableRelationshipCursor create() {
        return new ModifiableRelationshipCursor();
    }

    @Override
    public final long sourceId() {
        if (!this.sourceIdIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.sourceId;
    }

    @Override
    public final long targetId() {
        if (!this.targetIdIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.targetId;
    }

    @Override
    public final double property() {
        if (!this.propertyIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.property;
    }

    public ModifiableRelationshipCursor clear() {
        this.initBits = 7L;
        this.sourceId = 0L;
        this.targetId = 0L;
        this.property = 0.0;
        return this;
    }

    public ModifiableRelationshipCursor from(RelationshipCursor instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableRelationshipCursor) {
            this.from((ModifiableRelationshipCursor)instance);
            return this;
        }
        this.setSourceId(instance.sourceId());
        this.setTargetId(instance.targetId());
        this.setProperty(instance.property());
        return this;
    }

    public ModifiableRelationshipCursor from(ModifiableRelationshipCursor instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance.sourceIdIsSet()) {
            this.setSourceId(instance.sourceId());
        }
        if (instance.targetIdIsSet()) {
            this.setTargetId(instance.targetId());
        }
        if (instance.propertyIsSet()) {
            this.setProperty(instance.property());
        }
        return this;
    }

    public ModifiableRelationshipCursor setSourceId(long sourceId) {
        this.sourceId = sourceId;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public ModifiableRelationshipCursor setTargetId(long targetId) {
        this.targetId = targetId;
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public ModifiableRelationshipCursor setProperty(double property) {
        this.property = property;
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    public final boolean sourceIdIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    public final boolean targetIdIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    public final boolean propertyIsSet() {
        return (this.initBits & 4L) == 0L;
    }

    public final ModifiableRelationshipCursor unsetSourceId() {
        this.initBits |= 1L;
        this.sourceId = 0L;
        return this;
    }

    public final ModifiableRelationshipCursor unsetTargetId() {
        this.initBits |= 2L;
        this.targetId = 0L;
        return this;
    }

    public final ModifiableRelationshipCursor unsetProperty() {
        this.initBits |= 4L;
        this.property = 0.0;
        return this;
    }

    public final boolean isInitialized() {
        return this.initBits == 0L;
    }

    private void checkRequiredAttributes() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.sourceIdIsSet()) {
            attributes.add("sourceId");
        }
        if (!this.targetIdIsSet()) {
            attributes.add("targetId");
        }
        if (!this.propertyIsSet()) {
            attributes.add("property");
        }
        return "RelationshipCursor is not initialized, some of the required attributes are not set " + attributes;
    }

    public final RelationshipCursor toImmutable() {
        this.checkRequiredAttributes();
        return ImmutableRelationshipCursor.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableRelationshipCursor)) {
            return false;
        }
        ModifiableRelationshipCursor other = (ModifiableRelationshipCursor)another;
        if (!this.isInitialized() || !other.isInitialized()) {
            return false;
        }
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableRelationshipCursor another) {
        return this.sourceId == another.sourceId && this.targetId == another.targetId && Double.doubleToLongBits(this.property) == Double.doubleToLongBits(another.property);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.sourceId);
        h += (h << 5) + Long.hashCode(this.targetId);
        h += (h << 5) + Double.hashCode(this.property);
        return h;
    }

    public String toString() {
        return "ModifiableRelationshipCursor{sourceId=" + (Serializable)(this.sourceIdIsSet() ? Long.valueOf(this.sourceId()) : "?") + ", targetId=" + (Serializable)(this.targetIdIsSet() ? Long.valueOf(this.targetId()) : "?") + ", property=" + (Serializable)(this.propertyIsSet() ? Double.valueOf(this.property()) : "?") + "}";
    }
}

