/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import java.util.Collection;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.LongPredicate;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.BatchNodeIterable;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.loading.LabelInformation;
import org.neo4j.gds.core.utils.LazyBatchCollection;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongIterable;

public abstract class LabeledIdMap
implements IdMap {
    protected final LabelInformation labelInformation;
    private final long nodeCount;

    public LabeledIdMap(LabelInformation labelInformation, long nodeCount) {
        this.labelInformation = labelInformation;
        this.nodeCount = nodeCount;
    }

    @Override
    public long nodeCount() {
        return this.nodeCount;
    }

    @Override
    public void forEachNode(LongPredicate consumer) {
        long count = this.nodeCount();
        for (long i = 0L; i < count; ++i) {
            if (consumer.test(i)) continue;
            return;
        }
    }

    @Override
    public PrimitiveIterator.OfLong nodeIterator() {
        return new BatchNodeIterable.IdIterator(this.nodeCount());
    }

    @Override
    public PrimitiveIterator.OfLong nodeIterator(Set<NodeLabel> labels) {
        return this.labelInformation.nodeIterator(labels, this.nodeCount());
    }

    @Override
    public Collection<PrimitiveLongIterable> batchIterables(long batchSize) {
        return LazyBatchCollection.of(this.nodeCount(), batchSize, BatchNodeIterable.IdIterable::new);
    }

    @Override
    public Set<NodeLabel> availableNodeLabels() {
        return this.labelInformation.availableNodeLabels();
    }

    @Override
    public List<NodeLabel> nodeLabels(long mappedNodeId) {
        return this.labelInformation.nodeLabelsForNodeId(mappedNodeId);
    }

    @Override
    public void forEachNodeLabel(long mappedNodeId, IdMap.NodeLabelConsumer consumer) {
        this.labelInformation.forEachNodeLabel(mappedNodeId, consumer);
    }

    @Override
    public boolean hasLabel(long mappedNodeId, NodeLabel label) {
        return this.labelInformation.hasLabel(mappedNodeId, label);
    }
}

