/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.Relationships;

@ParametersAreNonnullByDefault
@Generated(from="Relationships.Topology", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableTopology
implements Relationships.Topology {
    private final AdjacencyList adjacencyList;
    private final long elementCount;
    private final Orientation orientation;
    private final boolean isMultiGraph;

    private ImmutableTopology(AdjacencyList adjacencyList, long elementCount, Orientation orientation, boolean isMultiGraph) {
        this.adjacencyList = Objects.requireNonNull(adjacencyList, "adjacencyList");
        this.elementCount = elementCount;
        this.orientation = Objects.requireNonNull(orientation, "orientation");
        this.isMultiGraph = isMultiGraph;
    }

    private ImmutableTopology(ImmutableTopology original, AdjacencyList adjacencyList, long elementCount, Orientation orientation, boolean isMultiGraph) {
        this.adjacencyList = adjacencyList;
        this.elementCount = elementCount;
        this.orientation = orientation;
        this.isMultiGraph = isMultiGraph;
    }

    @Override
    public AdjacencyList adjacencyList() {
        return this.adjacencyList;
    }

    @Override
    public long elementCount() {
        return this.elementCount;
    }

    @Override
    public Orientation orientation() {
        return this.orientation;
    }

    @Override
    public boolean isMultiGraph() {
        return this.isMultiGraph;
    }

    public final ImmutableTopology withAdjacencyList(AdjacencyList value) {
        if (this.adjacencyList == value) {
            return this;
        }
        AdjacencyList newValue = Objects.requireNonNull(value, "adjacencyList");
        return new ImmutableTopology(this, newValue, this.elementCount, this.orientation, this.isMultiGraph);
    }

    public final ImmutableTopology withElementCount(long value) {
        if (this.elementCount == value) {
            return this;
        }
        return new ImmutableTopology(this, this.adjacencyList, value, this.orientation, this.isMultiGraph);
    }

    public final ImmutableTopology withOrientation(Orientation value) {
        if (this.orientation == value) {
            return this;
        }
        Orientation newValue = Objects.requireNonNull(value, "orientation");
        if (this.orientation.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTopology(this, this.adjacencyList, this.elementCount, newValue, this.isMultiGraph);
    }

    public final ImmutableTopology withIsMultiGraph(boolean value) {
        if (this.isMultiGraph == value) {
            return this;
        }
        return new ImmutableTopology(this, this.adjacencyList, this.elementCount, this.orientation, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTopology && this.equalTo((ImmutableTopology)another);
    }

    private boolean equalTo(ImmutableTopology another) {
        return this.adjacencyList.equals(another.adjacencyList) && this.elementCount == another.elementCount && this.orientation.equals((Object)another.orientation) && this.isMultiGraph == another.isMultiGraph;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.adjacencyList.hashCode();
        h += (h << 5) + Long.hashCode(this.elementCount);
        h += (h << 5) + this.orientation.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isMultiGraph);
        return h;
    }

    public String toString() {
        return "Topology{adjacencyList=" + this.adjacencyList + ", elementCount=" + this.elementCount + ", orientation=" + this.orientation + ", isMultiGraph=" + this.isMultiGraph + "}";
    }

    public static Relationships.Topology of(AdjacencyList adjacencyList, long elementCount, Orientation orientation, boolean isMultiGraph) {
        return new ImmutableTopology(adjacencyList, elementCount, orientation, isMultiGraph);
    }

    public static Relationships.Topology copyOf(Relationships.Topology instance) {
        if (instance instanceof ImmutableTopology) {
            return (ImmutableTopology)instance;
        }
        return ImmutableTopology.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Relationships.Topology", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ADJACENCY_LIST = 1L;
        private static final long INIT_BIT_ELEMENT_COUNT = 2L;
        private static final long INIT_BIT_ORIENTATION = 4L;
        private static final long INIT_BIT_IS_MULTI_GRAPH = 8L;
        private long initBits = 15L;
        @Nullable
        private AdjacencyList adjacencyList;
        private long elementCount;
        @Nullable
        private Orientation orientation;
        private boolean isMultiGraph;

        private Builder() {
        }

        public final Builder from(Relationships.Topology instance) {
            Objects.requireNonNull(instance, "instance");
            this.adjacencyList(instance.adjacencyList());
            this.elementCount(instance.elementCount());
            this.orientation(instance.orientation());
            this.isMultiGraph(instance.isMultiGraph());
            return this;
        }

        public final Builder adjacencyList(AdjacencyList adjacencyList) {
            this.adjacencyList = Objects.requireNonNull(adjacencyList, "adjacencyList");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder elementCount(long elementCount) {
            this.elementCount = elementCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder orientation(Orientation orientation) {
            this.orientation = Objects.requireNonNull(orientation, "orientation");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder isMultiGraph(boolean isMultiGraph) {
            this.isMultiGraph = isMultiGraph;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Builder clear() {
            this.initBits = 15L;
            this.adjacencyList = null;
            this.elementCount = 0L;
            this.orientation = null;
            this.isMultiGraph = false;
            return this;
        }

        public Relationships.Topology build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTopology(null, this.adjacencyList, this.elementCount, this.orientation, this.isMultiGraph);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("adjacencyList");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("elementCount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("orientation");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("isMultiGraph");
            }
            return "Cannot build Topology, some of required attributes are not set " + attributes;
        }
    }
}

