/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.Relationships;

@ParametersAreNonnullByDefault
@Generated(from="Relationships", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableRelationships
implements Relationships {
    private final Relationships.Topology topology;
    @Nullable
    private final Relationships.Properties properties;

    private ImmutableRelationships(Relationships.Topology topology, Optional<? extends Relationships.Properties> properties) {
        this.topology = Objects.requireNonNull(topology, "topology");
        this.properties = properties.orElse(null);
    }

    private ImmutableRelationships(Relationships.Topology topology, @Nullable Relationships.Properties properties) {
        this.topology = Objects.requireNonNull(topology, "topology");
        this.properties = properties;
    }

    private ImmutableRelationships(ImmutableRelationships original, Relationships.Topology topology, @Nullable Relationships.Properties properties) {
        this.topology = topology;
        this.properties = properties;
    }

    @Override
    public Relationships.Topology topology() {
        return this.topology;
    }

    @Override
    public Optional<Relationships.Properties> properties() {
        return Optional.ofNullable(this.properties);
    }

    public final ImmutableRelationships withTopology(Relationships.Topology value) {
        if (this.topology == value) {
            return this;
        }
        Relationships.Topology newValue = Objects.requireNonNull(value, "topology");
        return new ImmutableRelationships(this, newValue, this.properties);
    }

    public final ImmutableRelationships withProperties(@Nullable Relationships.Properties value) {
        Relationships.Properties newValue = value;
        if (this.properties == newValue) {
            return this;
        }
        return new ImmutableRelationships(this, this.topology, newValue);
    }

    public final ImmutableRelationships withProperties(Optional<? extends Relationships.Properties> optional) {
        Relationships.Properties value = optional.orElse(null);
        if (this.properties == value) {
            return this;
        }
        return new ImmutableRelationships(this, this.topology, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelationships && this.equalTo((ImmutableRelationships)another);
    }

    private boolean equalTo(ImmutableRelationships another) {
        return this.topology.equals(another.topology) && Objects.equals(this.properties, another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.topology.hashCode();
        h += (h << 5) + Objects.hashCode(this.properties);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Relationships{");
        builder.append("topology=").append(this.topology);
        if (this.properties != null) {
            builder.append(", ");
            builder.append("properties=").append(this.properties);
        }
        return builder.append("}").toString();
    }

    public static Relationships of(Relationships.Topology topology, Optional<? extends Relationships.Properties> properties) {
        return new ImmutableRelationships(topology, properties);
    }

    public static Relationships of(Relationships.Topology topology, @Nullable Relationships.Properties properties) {
        return new ImmutableRelationships(topology, properties);
    }

    public static Relationships copyOf(Relationships instance) {
        if (instance instanceof ImmutableRelationships) {
            return (ImmutableRelationships)instance;
        }
        return ImmutableRelationships.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Relationships", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOPOLOGY = 1L;
        private long initBits = 1L;
        @Nullable
        private Relationships.Topology topology;
        @Nullable
        private Relationships.Properties properties;

        private Builder() {
        }

        public final Builder from(Relationships instance) {
            Objects.requireNonNull(instance, "instance");
            this.topology(instance.topology());
            Optional<Relationships.Properties> propertiesOptional = instance.properties();
            if (propertiesOptional.isPresent()) {
                this.properties(propertiesOptional);
            }
            return this;
        }

        public final Builder topology(Relationships.Topology topology) {
            this.topology = Objects.requireNonNull(topology, "topology");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder properties(@Nullable Relationships.Properties properties) {
            this.properties = properties;
            return this;
        }

        public final Builder properties(Optional<? extends Relationships.Properties> properties) {
            this.properties = properties.orElse(null);
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.topology = null;
            this.properties = null;
            return this;
        }

        public Relationships build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRelationships(null, this.topology, this.properties);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("topology");
            }
            return "Cannot build Relationships, some of required attributes are not set " + attributes;
        }
    }
}

