/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.RelationshipProperty;
import org.neo4j.gds.api.RelationshipPropertyStore;

@ParametersAreNonnullByDefault
@Generated(from="RelationshipPropertyStore", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableRelationshipPropertyStore
implements RelationshipPropertyStore {
    private final Map<String, RelationshipProperty> relationshipProperties;

    private ImmutableRelationshipPropertyStore(Map<String, ? extends RelationshipProperty> relationshipProperties) {
        this.relationshipProperties = ImmutableRelationshipPropertyStore.createUnmodifiableMap(true, false, relationshipProperties);
    }

    private ImmutableRelationshipPropertyStore(ImmutableRelationshipPropertyStore original, Map<String, RelationshipProperty> relationshipProperties) {
        this.relationshipProperties = relationshipProperties;
    }

    @Override
    public Map<String, RelationshipProperty> relationshipProperties() {
        return this.relationshipProperties;
    }

    public final ImmutableRelationshipPropertyStore withRelationshipProperties(Map<String, ? extends RelationshipProperty> entries) {
        if (this.relationshipProperties == entries) {
            return this;
        }
        Map<String, RelationshipProperty> newValue = ImmutableRelationshipPropertyStore.createUnmodifiableMap(true, false, entries);
        return new ImmutableRelationshipPropertyStore(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelationshipPropertyStore && this.equalTo((ImmutableRelationshipPropertyStore)another);
    }

    private boolean equalTo(ImmutableRelationshipPropertyStore another) {
        return this.relationshipProperties.equals(another.relationshipProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.relationshipProperties.hashCode();
        return h;
    }

    public String toString() {
        return "RelationshipPropertyStore{relationshipProperties=" + this.relationshipProperties + "}";
    }

    public static RelationshipPropertyStore of(Map<String, ? extends RelationshipProperty> relationshipProperties) {
        return new ImmutableRelationshipPropertyStore(relationshipProperties);
    }

    public static RelationshipPropertyStore copyOf(RelationshipPropertyStore instance) {
        if (instance instanceof ImmutableRelationshipPropertyStore) {
            return (ImmutableRelationshipPropertyStore)instance;
        }
        return new RelationshipPropertyStore.Builder().from(instance).build();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="RelationshipPropertyStore", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        protected Map<String, RelationshipProperty> relationshipProperties = null;

        public Builder() {
            if (!(this instanceof RelationshipPropertyStore.Builder)) {
                throw new UnsupportedOperationException("Use: new RelationshipPropertyStore.Builder()");
            }
        }

        public final RelationshipPropertyStore.Builder from(RelationshipPropertyStore instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllRelationshipProperties(instance.relationshipProperties());
            return (RelationshipPropertyStore.Builder)this;
        }

        public final RelationshipPropertyStore.Builder putRelationshipProperty(String key, RelationshipProperty value) {
            if (this.relationshipProperties == null) {
                this.relationshipProperties = new LinkedHashMap<String, RelationshipProperty>();
            }
            this.relationshipProperties.put(Objects.requireNonNull(key, "relationshipProperties key"), Objects.requireNonNull(value, "relationshipProperties value"));
            return (RelationshipPropertyStore.Builder)this;
        }

        public final RelationshipPropertyStore.Builder putRelationshipProperty(Map.Entry<String, ? extends RelationshipProperty> entry) {
            if (this.relationshipProperties == null) {
                this.relationshipProperties = new LinkedHashMap<String, RelationshipProperty>();
            }
            String k = entry.getKey();
            RelationshipProperty v = entry.getValue();
            this.relationshipProperties.put(Objects.requireNonNull(k, "relationshipProperties key"), Objects.requireNonNull(v, "relationshipProperties value"));
            return (RelationshipPropertyStore.Builder)this;
        }

        public final RelationshipPropertyStore.Builder relationshipProperties(Map<String, ? extends RelationshipProperty> entries) {
            this.relationshipProperties = new LinkedHashMap<String, RelationshipProperty>();
            return this.putAllRelationshipProperties(entries);
        }

        public final RelationshipPropertyStore.Builder putAllRelationshipProperties(Map<String, ? extends RelationshipProperty> entries) {
            if (this.relationshipProperties == null) {
                this.relationshipProperties = new LinkedHashMap<String, RelationshipProperty>();
            }
            for (Map.Entry<String, ? extends RelationshipProperty> e : entries.entrySet()) {
                String k = e.getKey();
                RelationshipProperty v = e.getValue();
                this.relationshipProperties.put(Objects.requireNonNull(k, "relationshipProperties key"), Objects.requireNonNull(v, "relationshipProperties value"));
            }
            return (RelationshipPropertyStore.Builder)this;
        }

        public RelationshipPropertyStore.Builder clear() {
            if (this.relationshipProperties != null) {
                this.relationshipProperties.clear();
            }
            return (RelationshipPropertyStore.Builder)this;
        }

        public RelationshipPropertyStore build() {
            return new ImmutableRelationshipPropertyStore(null, this.relationshipProperties == null ? Collections.emptyMap() : ImmutableRelationshipPropertyStore.createUnmodifiableMap(false, false, this.relationshipProperties));
        }
    }
}

