/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.RelationshipProperty;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.api.schema.RelationshipPropertySchema;

@ParametersAreNonnullByDefault
@Generated(from="RelationshipProperty", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableRelationshipProperty
implements RelationshipProperty {
    private final Relationships.Properties values;
    private final RelationshipPropertySchema propertySchema;

    private ImmutableRelationshipProperty(Relationships.Properties values, RelationshipPropertySchema propertySchema) {
        this.values = Objects.requireNonNull(values, "values");
        this.propertySchema = Objects.requireNonNull(propertySchema, "propertySchema");
    }

    private ImmutableRelationshipProperty(ImmutableRelationshipProperty original, Relationships.Properties values, RelationshipPropertySchema propertySchema) {
        this.values = values;
        this.propertySchema = propertySchema;
    }

    @Override
    public Relationships.Properties values() {
        return this.values;
    }

    @Override
    public RelationshipPropertySchema propertySchema() {
        return this.propertySchema;
    }

    public final ImmutableRelationshipProperty withValues(Relationships.Properties value) {
        if (this.values == value) {
            return this;
        }
        Relationships.Properties newValue = Objects.requireNonNull(value, "values");
        return new ImmutableRelationshipProperty(this, newValue, this.propertySchema);
    }

    public final ImmutableRelationshipProperty withPropertySchema(RelationshipPropertySchema value) {
        if (this.propertySchema == value) {
            return this;
        }
        RelationshipPropertySchema newValue = Objects.requireNonNull(value, "propertySchema");
        return new ImmutableRelationshipProperty(this, this.values, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelationshipProperty && this.equalTo((ImmutableRelationshipProperty)another);
    }

    private boolean equalTo(ImmutableRelationshipProperty another) {
        return this.values.equals(another.values) && this.propertySchema.equals(another.propertySchema);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.values.hashCode();
        h += (h << 5) + this.propertySchema.hashCode();
        return h;
    }

    public String toString() {
        return "RelationshipProperty{values=" + this.values + ", propertySchema=" + this.propertySchema + "}";
    }

    public static RelationshipProperty of(Relationships.Properties values, RelationshipPropertySchema propertySchema) {
        return new ImmutableRelationshipProperty(values, propertySchema);
    }

    public static RelationshipProperty copyOf(RelationshipProperty instance) {
        if (instance instanceof ImmutableRelationshipProperty) {
            return (ImmutableRelationshipProperty)instance;
        }
        return ImmutableRelationshipProperty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RelationshipProperty", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUES = 1L;
        private static final long INIT_BIT_PROPERTY_SCHEMA = 2L;
        private long initBits = 3L;
        @Nullable
        private Relationships.Properties values;
        @Nullable
        private RelationshipPropertySchema propertySchema;

        private Builder() {
        }

        public final Builder from(RelationshipProperty instance) {
            Objects.requireNonNull(instance, "instance");
            this.values(instance.values());
            this.propertySchema(instance.propertySchema());
            return this;
        }

        public final Builder values(Relationships.Properties values) {
            this.values = Objects.requireNonNull(values, "values");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder propertySchema(RelationshipPropertySchema propertySchema) {
            this.propertySchema = Objects.requireNonNull(propertySchema, "propertySchema");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.values = null;
            this.propertySchema = null;
            return this;
        }

        public RelationshipProperty build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRelationshipProperty(null, this.values, this.propertySchema);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("values");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("propertySchema");
            }
            return "Cannot build RelationshipProperty, some of required attributes are not set " + attributes;
        }
    }
}

