/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.ModifiableRelationshipCursor;
import org.neo4j.gds.api.RelationshipCursor;

@ParametersAreNonnullByDefault
@Generated(from="RelationshipCursor", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableRelationshipCursor
implements RelationshipCursor {
    private final long sourceId;
    private final long targetId;
    private final double property;

    private ImmutableRelationshipCursor(long sourceId, long targetId, double property) {
        this.sourceId = sourceId;
        this.targetId = targetId;
        this.property = property;
    }

    @Override
    public long sourceId() {
        return this.sourceId;
    }

    @Override
    public long targetId() {
        return this.targetId;
    }

    @Override
    public double property() {
        return this.property;
    }

    public final ImmutableRelationshipCursor withSourceId(long value) {
        if (this.sourceId == value) {
            return this;
        }
        return new ImmutableRelationshipCursor(value, this.targetId, this.property);
    }

    public final ImmutableRelationshipCursor withTargetId(long value) {
        if (this.targetId == value) {
            return this;
        }
        return new ImmutableRelationshipCursor(this.sourceId, value, this.property);
    }

    public final ImmutableRelationshipCursor withProperty(double value) {
        if (Double.doubleToLongBits(this.property) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableRelationshipCursor(this.sourceId, this.targetId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelationshipCursor && this.equalTo((ImmutableRelationshipCursor)another);
    }

    private boolean equalTo(ImmutableRelationshipCursor another) {
        return this.sourceId == another.sourceId && this.targetId == another.targetId && Double.doubleToLongBits(this.property) == Double.doubleToLongBits(another.property);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.sourceId);
        h += (h << 5) + Long.hashCode(this.targetId);
        h += (h << 5) + Double.hashCode(this.property);
        return h;
    }

    public String toString() {
        return "RelationshipCursor{sourceId=" + this.sourceId + ", targetId=" + this.targetId + ", property=" + this.property + "}";
    }

    public static RelationshipCursor of(long sourceId, long targetId, double property) {
        return new ImmutableRelationshipCursor(sourceId, targetId, property);
    }

    public static RelationshipCursor copyOf(RelationshipCursor instance) {
        if (instance instanceof ImmutableRelationshipCursor) {
            return (ImmutableRelationshipCursor)instance;
        }
        return ImmutableRelationshipCursor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RelationshipCursor", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_ID = 1L;
        private static final long INIT_BIT_TARGET_ID = 2L;
        private static final long INIT_BIT_PROPERTY = 4L;
        private long initBits = 7L;
        private long sourceId;
        private long targetId;
        private double property;

        private Builder() {
        }

        public final Builder from(ModifiableRelationshipCursor instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance.sourceIdIsSet()) {
                this.sourceId(instance.sourceId());
            }
            if (instance.targetIdIsSet()) {
                this.targetId(instance.targetId());
            }
            if (instance.propertyIsSet()) {
                this.property(instance.property());
            }
            return this;
        }

        public final Builder from(RelationshipCursor instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableRelationshipCursor) {
                return this.from((ModifiableRelationshipCursor)instance);
            }
            this.sourceId(instance.sourceId());
            this.targetId(instance.targetId());
            this.property(instance.property());
            return this;
        }

        public final Builder sourceId(long sourceId) {
            this.sourceId = sourceId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder targetId(long targetId) {
            this.targetId = targetId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder property(double property) {
            this.property = property;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.sourceId = 0L;
            this.targetId = 0L;
            this.property = 0.0;
            return this;
        }

        public RelationshipCursor build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRelationshipCursor(this.sourceId, this.targetId, this.property);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("property");
            }
            return "Cannot build RelationshipCursor, some of required attributes are not set " + attributes;
        }
    }
}

