/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.api.AdjacencyProperties;
import org.neo4j.gds.api.Relationships;

@ParametersAreNonnullByDefault
@Generated(from="Relationships.Properties", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableProperties
implements Relationships.Properties {
    private final AdjacencyProperties propertiesList;
    private final long elementCount;
    private final Orientation orientation;
    private final boolean isMultiGraph;
    private final double defaultPropertyValue;

    private ImmutableProperties(AdjacencyProperties propertiesList, long elementCount, Orientation orientation, boolean isMultiGraph, double defaultPropertyValue) {
        this.propertiesList = Objects.requireNonNull(propertiesList, "propertiesList");
        this.elementCount = elementCount;
        this.orientation = Objects.requireNonNull(orientation, "orientation");
        this.isMultiGraph = isMultiGraph;
        this.defaultPropertyValue = defaultPropertyValue;
    }

    private ImmutableProperties(ImmutableProperties original, AdjacencyProperties propertiesList, long elementCount, Orientation orientation, boolean isMultiGraph, double defaultPropertyValue) {
        this.propertiesList = propertiesList;
        this.elementCount = elementCount;
        this.orientation = orientation;
        this.isMultiGraph = isMultiGraph;
        this.defaultPropertyValue = defaultPropertyValue;
    }

    @Override
    public AdjacencyProperties propertiesList() {
        return this.propertiesList;
    }

    @Override
    public long elementCount() {
        return this.elementCount;
    }

    @Override
    public Orientation orientation() {
        return this.orientation;
    }

    @Override
    public boolean isMultiGraph() {
        return this.isMultiGraph;
    }

    @Override
    public double defaultPropertyValue() {
        return this.defaultPropertyValue;
    }

    public final ImmutableProperties withPropertiesList(AdjacencyProperties value) {
        if (this.propertiesList == value) {
            return this;
        }
        AdjacencyProperties newValue = Objects.requireNonNull(value, "propertiesList");
        return new ImmutableProperties(this, newValue, this.elementCount, this.orientation, this.isMultiGraph, this.defaultPropertyValue);
    }

    public final ImmutableProperties withElementCount(long value) {
        if (this.elementCount == value) {
            return this;
        }
        return new ImmutableProperties(this, this.propertiesList, value, this.orientation, this.isMultiGraph, this.defaultPropertyValue);
    }

    public final ImmutableProperties withOrientation(Orientation value) {
        if (this.orientation == value) {
            return this;
        }
        Orientation newValue = Objects.requireNonNull(value, "orientation");
        if (this.orientation.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableProperties(this, this.propertiesList, this.elementCount, newValue, this.isMultiGraph, this.defaultPropertyValue);
    }

    public final ImmutableProperties withIsMultiGraph(boolean value) {
        if (this.isMultiGraph == value) {
            return this;
        }
        return new ImmutableProperties(this, this.propertiesList, this.elementCount, this.orientation, value, this.defaultPropertyValue);
    }

    public final ImmutableProperties withDefaultPropertyValue(double value) {
        if (Double.doubleToLongBits(this.defaultPropertyValue) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableProperties(this, this.propertiesList, this.elementCount, this.orientation, this.isMultiGraph, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProperties && this.equalTo((ImmutableProperties)another);
    }

    private boolean equalTo(ImmutableProperties another) {
        return this.propertiesList.equals(another.propertiesList) && this.elementCount == another.elementCount && this.orientation.equals((Object)another.orientation) && this.isMultiGraph == another.isMultiGraph && Double.doubleToLongBits(this.defaultPropertyValue) == Double.doubleToLongBits(another.defaultPropertyValue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.propertiesList.hashCode();
        h += (h << 5) + Long.hashCode(this.elementCount);
        h += (h << 5) + this.orientation.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isMultiGraph);
        h += (h << 5) + Double.hashCode(this.defaultPropertyValue);
        return h;
    }

    public String toString() {
        return "Properties{propertiesList=" + this.propertiesList + ", elementCount=" + this.elementCount + ", orientation=" + this.orientation + ", isMultiGraph=" + this.isMultiGraph + ", defaultPropertyValue=" + this.defaultPropertyValue + "}";
    }

    public static Relationships.Properties of(AdjacencyProperties propertiesList, long elementCount, Orientation orientation, boolean isMultiGraph, double defaultPropertyValue) {
        return new ImmutableProperties(propertiesList, elementCount, orientation, isMultiGraph, defaultPropertyValue);
    }

    public static Relationships.Properties copyOf(Relationships.Properties instance) {
        if (instance instanceof ImmutableProperties) {
            return (ImmutableProperties)instance;
        }
        return ImmutableProperties.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Relationships.Properties", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PROPERTIES_LIST = 1L;
        private static final long INIT_BIT_ELEMENT_COUNT = 2L;
        private static final long INIT_BIT_ORIENTATION = 4L;
        private static final long INIT_BIT_IS_MULTI_GRAPH = 8L;
        private static final long INIT_BIT_DEFAULT_PROPERTY_VALUE = 16L;
        private long initBits = 31L;
        @Nullable
        private AdjacencyProperties propertiesList;
        private long elementCount;
        @Nullable
        private Orientation orientation;
        private boolean isMultiGraph;
        private double defaultPropertyValue;

        private Builder() {
        }

        public final Builder from(Relationships.Properties instance) {
            Objects.requireNonNull(instance, "instance");
            this.propertiesList(instance.propertiesList());
            this.elementCount(instance.elementCount());
            this.orientation(instance.orientation());
            this.isMultiGraph(instance.isMultiGraph());
            this.defaultPropertyValue(instance.defaultPropertyValue());
            return this;
        }

        public final Builder propertiesList(AdjacencyProperties propertiesList) {
            this.propertiesList = Objects.requireNonNull(propertiesList, "propertiesList");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder elementCount(long elementCount) {
            this.elementCount = elementCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder orientation(Orientation orientation) {
            this.orientation = Objects.requireNonNull(orientation, "orientation");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder isMultiGraph(boolean isMultiGraph) {
            this.isMultiGraph = isMultiGraph;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder defaultPropertyValue(double defaultPropertyValue) {
            this.defaultPropertyValue = defaultPropertyValue;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder clear() {
            this.initBits = 31L;
            this.propertiesList = null;
            this.elementCount = 0L;
            this.orientation = null;
            this.isMultiGraph = false;
            this.defaultPropertyValue = 0.0;
            return this;
        }

        public Relationships.Properties build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProperties(null, this.propertiesList, this.elementCount, this.orientation, this.isMultiGraph, this.defaultPropertyValue);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("propertiesList");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("elementCount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("orientation");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("isMultiGraph");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("defaultPropertyValue");
            }
            return "Cannot build Properties, some of required attributes are not set " + attributes;
        }
    }
}

