/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.GraphStoreFactory;

@ParametersAreNonnullByDefault
@Generated(from="GraphStoreFactory.ImportResult", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableImportResult<STORE extends GraphStore>
implements GraphStoreFactory.ImportResult<STORE> {
    private final STORE graphStore;

    private ImmutableImportResult(STORE graphStore) {
        this.graphStore = (GraphStore)Objects.requireNonNull(graphStore, "graphStore");
    }

    private ImmutableImportResult(ImmutableImportResult<STORE> original, STORE graphStore) {
        this.graphStore = graphStore;
    }

    @Override
    public STORE graphStore() {
        return this.graphStore;
    }

    public final ImmutableImportResult<STORE> withGraphStore(STORE value) {
        if (this.graphStore == value) {
            return this;
        }
        GraphStore newValue = (GraphStore)Objects.requireNonNull(value, "graphStore");
        return new ImmutableImportResult<GraphStore>(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImportResult && this.equalTo((ImmutableImportResult)another);
    }

    private boolean equalTo(ImmutableImportResult<?> another) {
        return this.graphStore.equals(another.graphStore);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.graphStore.hashCode();
        return h;
    }

    public String toString() {
        return "ImportResult{graphStore=" + this.graphStore + "}";
    }

    public static <STORE extends GraphStore> GraphStoreFactory.ImportResult<STORE> of(STORE graphStore) {
        return new ImmutableImportResult<STORE>(graphStore);
    }

    public static <STORE extends GraphStore> GraphStoreFactory.ImportResult<STORE> copyOf(GraphStoreFactory.ImportResult<STORE> instance) {
        if (instance instanceof ImmutableImportResult) {
            return (ImmutableImportResult)instance;
        }
        return ImmutableImportResult.builder().from(instance).build();
    }

    public static <STORE extends GraphStore> Builder<STORE> builder() {
        return new Builder();
    }

    @Generated(from="GraphStoreFactory.ImportResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<STORE extends GraphStore> {
        private static final long INIT_BIT_GRAPH_STORE = 1L;
        private long initBits = 1L;
        @Nullable
        private STORE graphStore;

        private Builder() {
        }

        public final Builder<STORE> from(GraphStoreFactory.ImportResult<STORE> instance) {
            Objects.requireNonNull(instance, "instance");
            this.graphStore(instance.graphStore());
            return this;
        }

        public final Builder<STORE> graphStore(STORE graphStore) {
            this.graphStore = (GraphStore)Objects.requireNonNull(graphStore, "graphStore");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder<STORE> clear() {
            this.initBits = 1L;
            this.graphStore = null;
            return this;
        }

        public GraphStoreFactory.ImportResult<STORE> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableImportResult<STORE>(null, this.graphStore);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("graphStore");
            }
            return "Cannot build ImportResult, some of required attributes are not set " + attributes;
        }
    }
}

