/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.Log;

@ParametersAreNonnullByDefault
@Generated(from="GraphLoaderContext", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableGraphLoaderContext
implements GraphLoaderContext {
    private final TransactionContext transactionContext;
    private final GraphDatabaseService graphDatabaseService;
    private final Log log;
    private final ExecutorService executor;
    private final TerminationFlag terminationFlag;
    private final TaskRegistryFactory taskRegistryFactory;
    private final UserLogRegistryFactory userLogRegistryFactory;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGraphLoaderContext(TransactionContext transactionContext, GraphDatabaseService graphDatabaseService, Log log, ExecutorService executor, TerminationFlag terminationFlag, TaskRegistryFactory taskRegistryFactory, UserLogRegistryFactory userLogRegistryFactory) {
        this.transactionContext = Objects.requireNonNull(transactionContext, "transactionContext");
        this.graphDatabaseService = Objects.requireNonNull(graphDatabaseService, "graphDatabaseService");
        this.log = Objects.requireNonNull(log, "log");
        this.executor = Objects.requireNonNull(executor, "executor");
        this.terminationFlag = Objects.requireNonNull(terminationFlag, "terminationFlag");
        this.taskRegistryFactory = Objects.requireNonNull(taskRegistryFactory, "taskRegistryFactory");
        this.userLogRegistryFactory = Objects.requireNonNull(userLogRegistryFactory, "userLogRegistryFactory");
        this.initShim = null;
    }

    private ImmutableGraphLoaderContext(Builder builder) {
        this.transactionContext = builder.transactionContext;
        this.graphDatabaseService = builder.graphDatabaseService;
        this.log = builder.log;
        this.taskRegistryFactory = builder.taskRegistryFactory;
        this.userLogRegistryFactory = builder.userLogRegistryFactory;
        if (builder.executor != null) {
            this.initShim.executor(builder.executor);
        }
        if (builder.terminationFlag != null) {
            this.initShim.terminationFlag(builder.terminationFlag);
        }
        this.executor = this.initShim.executor();
        this.terminationFlag = this.initShim.terminationFlag();
        this.initShim = null;
    }

    private ImmutableGraphLoaderContext(ImmutableGraphLoaderContext original, TransactionContext transactionContext, GraphDatabaseService graphDatabaseService, Log log, ExecutorService executor, TerminationFlag terminationFlag, TaskRegistryFactory taskRegistryFactory, UserLogRegistryFactory userLogRegistryFactory) {
        this.transactionContext = transactionContext;
        this.graphDatabaseService = graphDatabaseService;
        this.log = log;
        this.executor = executor;
        this.terminationFlag = terminationFlag;
        this.taskRegistryFactory = taskRegistryFactory;
        this.userLogRegistryFactory = userLogRegistryFactory;
        this.initShim = null;
    }

    private ExecutorService executorInitialize() {
        return GraphLoaderContext.super.executor();
    }

    private TerminationFlag terminationFlagInitialize() {
        return GraphLoaderContext.super.terminationFlag();
    }

    @Override
    public TransactionContext transactionContext() {
        return this.transactionContext;
    }

    @Override
    public GraphDatabaseService graphDatabaseService() {
        return this.graphDatabaseService;
    }

    @Override
    public Log log() {
        return this.log;
    }

    @Override
    public ExecutorService executor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.executor() : this.executor;
    }

    @Override
    public TerminationFlag terminationFlag() {
        InitShim shim = this.initShim;
        return shim != null ? shim.terminationFlag() : this.terminationFlag;
    }

    @Override
    public TaskRegistryFactory taskRegistryFactory() {
        return this.taskRegistryFactory;
    }

    @Override
    public UserLogRegistryFactory userLogRegistryFactory() {
        return this.userLogRegistryFactory;
    }

    public final ImmutableGraphLoaderContext withTransactionContext(TransactionContext value) {
        if (this.transactionContext == value) {
            return this;
        }
        TransactionContext newValue = Objects.requireNonNull(value, "transactionContext");
        return new ImmutableGraphLoaderContext(this, newValue, this.graphDatabaseService, this.log, this.executor, this.terminationFlag, this.taskRegistryFactory, this.userLogRegistryFactory);
    }

    public final ImmutableGraphLoaderContext withGraphDatabaseService(GraphDatabaseService value) {
        if (this.graphDatabaseService == value) {
            return this;
        }
        GraphDatabaseService newValue = Objects.requireNonNull(value, "graphDatabaseService");
        return new ImmutableGraphLoaderContext(this, this.transactionContext, newValue, this.log, this.executor, this.terminationFlag, this.taskRegistryFactory, this.userLogRegistryFactory);
    }

    public final ImmutableGraphLoaderContext withLog(Log value) {
        if (this.log == value) {
            return this;
        }
        Log newValue = Objects.requireNonNull(value, "log");
        return new ImmutableGraphLoaderContext(this, this.transactionContext, this.graphDatabaseService, newValue, this.executor, this.terminationFlag, this.taskRegistryFactory, this.userLogRegistryFactory);
    }

    public final ImmutableGraphLoaderContext withExecutor(ExecutorService value) {
        if (this.executor == value) {
            return this;
        }
        ExecutorService newValue = Objects.requireNonNull(value, "executor");
        return new ImmutableGraphLoaderContext(this, this.transactionContext, this.graphDatabaseService, this.log, newValue, this.terminationFlag, this.taskRegistryFactory, this.userLogRegistryFactory);
    }

    public final ImmutableGraphLoaderContext withTerminationFlag(TerminationFlag value) {
        if (this.terminationFlag == value) {
            return this;
        }
        TerminationFlag newValue = Objects.requireNonNull(value, "terminationFlag");
        return new ImmutableGraphLoaderContext(this, this.transactionContext, this.graphDatabaseService, this.log, this.executor, newValue, this.taskRegistryFactory, this.userLogRegistryFactory);
    }

    public final ImmutableGraphLoaderContext withTaskRegistryFactory(TaskRegistryFactory value) {
        if (this.taskRegistryFactory == value) {
            return this;
        }
        TaskRegistryFactory newValue = Objects.requireNonNull(value, "taskRegistryFactory");
        return new ImmutableGraphLoaderContext(this, this.transactionContext, this.graphDatabaseService, this.log, this.executor, this.terminationFlag, newValue, this.userLogRegistryFactory);
    }

    public final ImmutableGraphLoaderContext withUserLogRegistryFactory(UserLogRegistryFactory value) {
        if (this.userLogRegistryFactory == value) {
            return this;
        }
        UserLogRegistryFactory newValue = Objects.requireNonNull(value, "userLogRegistryFactory");
        return new ImmutableGraphLoaderContext(this, this.transactionContext, this.graphDatabaseService, this.log, this.executor, this.terminationFlag, this.taskRegistryFactory, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphLoaderContext && this.equalTo((ImmutableGraphLoaderContext)another);
    }

    private boolean equalTo(ImmutableGraphLoaderContext another) {
        return this.transactionContext.equals(another.transactionContext) && this.graphDatabaseService.equals(another.graphDatabaseService) && this.log.equals(another.log) && this.executor.equals(another.executor) && this.terminationFlag.equals(another.terminationFlag) && this.taskRegistryFactory.equals(another.taskRegistryFactory) && this.userLogRegistryFactory.equals(another.userLogRegistryFactory);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transactionContext.hashCode();
        h += (h << 5) + this.graphDatabaseService.hashCode();
        h += (h << 5) + this.log.hashCode();
        h += (h << 5) + this.executor.hashCode();
        h += (h << 5) + this.terminationFlag.hashCode();
        h += (h << 5) + this.taskRegistryFactory.hashCode();
        h += (h << 5) + this.userLogRegistryFactory.hashCode();
        return h;
    }

    public String toString() {
        return "GraphLoaderContext{transactionContext=" + this.transactionContext + ", graphDatabaseService=" + this.graphDatabaseService + ", log=" + this.log + ", executor=" + this.executor + ", terminationFlag=" + this.terminationFlag + ", taskRegistryFactory=" + this.taskRegistryFactory + ", userLogRegistryFactory=" + this.userLogRegistryFactory + "}";
    }

    public static GraphLoaderContext of(TransactionContext transactionContext, GraphDatabaseService graphDatabaseService, Log log, ExecutorService executor, TerminationFlag terminationFlag, TaskRegistryFactory taskRegistryFactory, UserLogRegistryFactory userLogRegistryFactory) {
        return new ImmutableGraphLoaderContext(transactionContext, graphDatabaseService, log, executor, terminationFlag, taskRegistryFactory, userLogRegistryFactory);
    }

    public static GraphLoaderContext copyOf(GraphLoaderContext instance) {
        if (instance instanceof ImmutableGraphLoaderContext) {
            return (ImmutableGraphLoaderContext)instance;
        }
        return ImmutableGraphLoaderContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GraphLoaderContext", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION_CONTEXT = 1L;
        private static final long INIT_BIT_GRAPH_DATABASE_SERVICE = 2L;
        private static final long INIT_BIT_LOG = 4L;
        private static final long INIT_BIT_TASK_REGISTRY_FACTORY = 8L;
        private static final long INIT_BIT_USER_LOG_REGISTRY_FACTORY = 16L;
        private long initBits = 31L;
        @Nullable
        private TransactionContext transactionContext;
        @Nullable
        private GraphDatabaseService graphDatabaseService;
        @Nullable
        private Log log;
        @Nullable
        private ExecutorService executor;
        @Nullable
        private TerminationFlag terminationFlag;
        @Nullable
        private TaskRegistryFactory taskRegistryFactory;
        @Nullable
        private UserLogRegistryFactory userLogRegistryFactory;

        private Builder() {
        }

        public final Builder from(GraphLoaderContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.transactionContext(instance.transactionContext());
            this.graphDatabaseService(instance.graphDatabaseService());
            this.log(instance.log());
            this.executor(instance.executor());
            this.terminationFlag(instance.terminationFlag());
            this.taskRegistryFactory(instance.taskRegistryFactory());
            this.userLogRegistryFactory(instance.userLogRegistryFactory());
            return this;
        }

        public final Builder transactionContext(TransactionContext transactionContext) {
            this.transactionContext = Objects.requireNonNull(transactionContext, "transactionContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder graphDatabaseService(GraphDatabaseService graphDatabaseService) {
            this.graphDatabaseService = Objects.requireNonNull(graphDatabaseService, "graphDatabaseService");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder log(Log log) {
            this.log = Objects.requireNonNull(log, "log");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder executor(ExecutorService executor) {
            this.executor = Objects.requireNonNull(executor, "executor");
            return this;
        }

        public final Builder terminationFlag(TerminationFlag terminationFlag) {
            this.terminationFlag = Objects.requireNonNull(terminationFlag, "terminationFlag");
            return this;
        }

        public final Builder taskRegistryFactory(TaskRegistryFactory taskRegistryFactory) {
            this.taskRegistryFactory = Objects.requireNonNull(taskRegistryFactory, "taskRegistryFactory");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder userLogRegistryFactory(UserLogRegistryFactory userLogRegistryFactory) {
            this.userLogRegistryFactory = Objects.requireNonNull(userLogRegistryFactory, "userLogRegistryFactory");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder clear() {
            this.initBits = 31L;
            this.transactionContext = null;
            this.graphDatabaseService = null;
            this.log = null;
            this.executor = null;
            this.terminationFlag = null;
            this.taskRegistryFactory = null;
            this.userLogRegistryFactory = null;
            return this;
        }

        public GraphLoaderContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGraphLoaderContext(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionContext");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("graphDatabaseService");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("log");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("taskRegistryFactory");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("userLogRegistryFactory");
            }
            return "Cannot build GraphLoaderContext, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="GraphLoaderContext", generator="Immutables")
    private final class InitShim {
        private byte executorBuildStage = 0;
        private ExecutorService executor;
        private byte terminationFlagBuildStage = 0;
        private TerminationFlag terminationFlag;

        private InitShim() {
        }

        ExecutorService executor() {
            if (this.executorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.executorBuildStage == 0) {
                this.executorBuildStage = (byte)-1;
                this.executor = Objects.requireNonNull(ImmutableGraphLoaderContext.this.executorInitialize(), "executor");
                this.executorBuildStage = 1;
            }
            return this.executor;
        }

        void executor(ExecutorService executor) {
            this.executor = executor;
            this.executorBuildStage = 1;
        }

        TerminationFlag terminationFlag() {
            if (this.terminationFlagBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.terminationFlagBuildStage == 0) {
                this.terminationFlagBuildStage = (byte)-1;
                this.terminationFlag = Objects.requireNonNull(ImmutableGraphLoaderContext.this.terminationFlagInitialize(), "terminationFlag");
                this.terminationFlagBuildStage = 1;
            }
            return this.terminationFlag;
        }

        void terminationFlag(TerminationFlag terminationFlag) {
            this.terminationFlag = terminationFlag;
            this.terminationFlagBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.executorBuildStage == -1) {
                attributes.add("executor");
            }
            if (this.terminationFlagBuildStage == -1) {
                attributes.add("terminationFlag");
            }
            return "Cannot build GraphLoaderContext, attribute initializers form cycle " + attributes;
        }
    }
}

