/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.LongPredicate;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.FilteredIdMap;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongIterable;

public abstract class IdMapAdapter
implements IdMap {
    private final IdMap idMap;

    public IdMapAdapter(IdMap idMap) {
        this.idMap = idMap;
    }

    @Override
    public Collection<PrimitiveLongIterable> batchIterables(long batchSize) {
        return this.idMap.batchIterables(batchSize);
    }

    @Override
    public long toMappedNodeId(long originalNodeId) {
        return this.idMap.toMappedNodeId(originalNodeId);
    }

    @Override
    public long toOriginalNodeId(long mappedNodeId) {
        return this.idMap.toOriginalNodeId(mappedNodeId);
    }

    @Override
    public long toRootNodeId(long mappedNodeId) {
        return this.idMap.toRootNodeId(mappedNodeId);
    }

    @Override
    public IdMap rootIdMap() {
        return this.idMap.rootIdMap();
    }

    @Override
    public boolean contains(long originalNodeId) {
        return this.idMap.contains(originalNodeId);
    }

    @Override
    public long nodeCount() {
        return this.idMap.nodeCount();
    }

    @Override
    public OptionalLong rootNodeCount() {
        return this.idMap.rootNodeCount();
    }

    @Override
    public long highestNeoId() {
        return this.idMap.highestNeoId();
    }

    @Override
    public void forEachNode(LongPredicate consumer) {
        this.idMap.forEachNode(consumer);
    }

    @Override
    public PrimitiveIterator.OfLong nodeIterator() {
        return this.idMap.nodeIterator();
    }

    @Override
    public PrimitiveIterator.OfLong nodeIterator(Set<NodeLabel> labels) {
        return this.idMap.nodeIterator(labels);
    }

    @Override
    public List<NodeLabel> nodeLabels(long mappedNodeId) {
        return this.idMap.nodeLabels(mappedNodeId);
    }

    @Override
    public void forEachNodeLabel(long mappedNodeId, IdMap.NodeLabelConsumer consumer) {
        this.idMap.forEachNodeLabel(mappedNodeId, consumer);
    }

    @Override
    public Set<NodeLabel> availableNodeLabels() {
        return this.idMap.availableNodeLabels();
    }

    @Override
    public boolean hasLabel(long mappedNodeId, NodeLabel label) {
        return this.idMap.hasLabel(mappedNodeId, label);
    }

    @Override
    public Optional<? extends FilteredIdMap> withFilteredLabels(Collection<NodeLabel> nodeLabels, int concurrency) {
        return this.idMap.withFilteredLabels(nodeLabels, concurrency);
    }
}

