/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.BatchNodeIterable;
import org.neo4j.gds.api.FilteredIdMap;
import org.neo4j.gds.api.NodeIterator;
import org.neo4j.gds.api.PartialIdMap;

public interface IdMap
extends PartialIdMap,
NodeIterator,
BatchNodeIterable {
    public static final long START_NODE_ID = 0L;
    public static final long NOT_FOUND = -1L;

    default public long safeToMappedNodeId(long originalNodeId) {
        return this.highestNeoId() < originalNodeId ? -1L : this.toMappedNodeId(originalNodeId);
    }

    public long toOriginalNodeId(long var1);

    public long toRootNodeId(long var1);

    public boolean contains(long var1);

    public long nodeCount();

    public long highestNeoId();

    public List<NodeLabel> nodeLabels(long var1);

    public void forEachNodeLabel(long var1, NodeLabelConsumer var3);

    public Set<NodeLabel> availableNodeLabels();

    public boolean hasLabel(long var1, NodeLabel var3);

    public IdMap rootIdMap();

    default public Optional<? extends FilteredIdMap> withFilteredLabels(Collection<NodeLabel> nodeLabels, int concurrency) {
        throw new UnsupportedOperationException("This node mapping does not support label filtering");
    }

    @FunctionalInterface
    public static interface NodeLabelConsumer {
        public boolean accept(NodeLabel var1);
    }
}

