/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.ImmutableImportResult;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.loading.Capabilities;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

public abstract class GraphStoreFactory<STORE extends GraphStore, CONFIG extends GraphProjectConfig> {
    protected final CONFIG graphProjectConfig;
    protected final Capabilities capabilities;
    protected final GraphLoaderContext loadingContext;
    protected final GraphDimensions dimensions;
    protected final ProgressTracker progressTracker;

    public GraphStoreFactory(CONFIG graphProjectConfig, Capabilities capabilities, GraphLoaderContext loadingContext, GraphDimensions dimensions) {
        this.graphProjectConfig = graphProjectConfig;
        this.capabilities = capabilities;
        this.loadingContext = loadingContext;
        this.dimensions = dimensions;
        this.progressTracker = this.initProgressTracker();
    }

    public abstract STORE build();

    public abstract MemoryEstimation estimateMemoryUsageDuringLoading();

    public abstract MemoryEstimation estimateMemoryUsageAfterLoading();

    public GraphDimensions dimensions() {
        return this.dimensions;
    }

    public GraphDimensions estimationDimensions() {
        return this.dimensions;
    }

    public CONFIG graphProjectConfig() {
        return this.graphProjectConfig;
    }

    protected abstract ProgressTracker initProgressTracker();

    @ValueClass
    public static interface ImportResult<STORE extends GraphStore> {
        public STORE graphStore();

        public static <STORE extends GraphStore> ImportResult<STORE> of(STORE graphStore) {
            return ImmutableImportResult.builder().graphStore(graphStore).build();
        }
    }

    public static interface Supplier {
        public GraphStoreFactory<? extends GraphStore, ? extends GraphProjectConfig> get(GraphLoaderContext var1);

        default public GraphStoreFactory<? extends GraphStore, ? extends GraphProjectConfig> getWithDimension(GraphLoaderContext loaderContext, GraphDimensions graphDimensions) {
            return this.get(loaderContext);
        }
    }
}

