/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.CompositeRelationshipIterator;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.GraphStoreWrapper;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.RelationshipProperty;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.graph.GraphProperty;
import org.neo4j.gds.api.properties.graph.GraphPropertyValues;
import org.neo4j.gds.api.properties.nodes.NodeProperty;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.core.loading.Capabilities;
import org.neo4j.gds.core.loading.DeletionResult;
import org.neo4j.values.storable.NumberType;

public abstract class GraphStoreAdapter
implements GraphStoreWrapper {
    private final GraphStore graphStore;

    protected GraphStoreAdapter(GraphStore graphStore) {
        this.graphStore = graphStore;
    }

    @Override
    public GraphStore innerGraphStore() {
        return this.graphStore;
    }

    @Override
    public DatabaseId databaseId() {
        return this.graphStore.databaseId();
    }

    @Override
    public Capabilities capabilities() {
        return this.graphStore.capabilities();
    }

    @Override
    public GraphSchema schema() {
        return this.graphStore.schema();
    }

    @Override
    public ZonedDateTime modificationTime() {
        return this.graphStore.modificationTime();
    }

    @Override
    public Set<String> graphPropertyKeys() {
        return this.graphStore.graphPropertyKeys();
    }

    @Override
    public boolean hasGraphProperty(String propertyKey) {
        return this.graphStore.hasGraphProperty(propertyKey);
    }

    @Override
    public GraphProperty graphProperty(String propertyKey) {
        return this.graphStore.graphProperty(propertyKey);
    }

    @Override
    public ValueType graphPropertyType(String propertyKey) {
        return this.graphStore.graphPropertyType(propertyKey);
    }

    @Override
    public GraphPropertyValues graphPropertyValues(String propertyKey) {
        return this.graphStore.graphPropertyValues(propertyKey);
    }

    @Override
    public void addGraphProperty(String propertyKey, GraphPropertyValues propertyValues) {
        this.graphStore.addGraphProperty(propertyKey, propertyValues);
    }

    @Override
    public void removeGraphProperty(String propertyKey) {
        this.graphStore.removeGraphProperty(propertyKey);
    }

    @Override
    public long nodeCount() {
        return this.graphStore.nodeCount();
    }

    @Override
    public IdMap nodes() {
        return this.graphStore.nodes();
    }

    @Override
    public Set<NodeLabel> nodeLabels() {
        return this.graphStore.nodeLabels();
    }

    @Override
    public Set<String> nodePropertyKeys(NodeLabel label) {
        return this.graphStore.nodePropertyKeys(label);
    }

    @Override
    public Set<String> nodePropertyKeys() {
        return this.graphStore.nodePropertyKeys();
    }

    @Override
    public boolean hasNodeProperty(String propertyKey) {
        return this.graphStore.hasNodeProperty(propertyKey);
    }

    @Override
    public boolean hasNodeProperty(NodeLabel label, String propertyKey) {
        return this.graphStore.hasNodeProperty(label, propertyKey);
    }

    @Override
    public boolean hasNodeProperty(Collection<NodeLabel> labels, String propertyKey) {
        return this.graphStore.hasNodeProperty(labels, propertyKey);
    }

    @Override
    public Collection<String> nodePropertyKeys(Collection<NodeLabel> labels) {
        return this.graphStore.nodePropertyKeys(labels);
    }

    @Override
    public NodeProperty nodeProperty(String propertyKey) {
        return this.graphStore.nodeProperty(propertyKey);
    }

    @Override
    public void addNodeProperty(Set<NodeLabel> nodeLabels, String propertyKey, NodePropertyValues propertyValues) {
        this.graphStore.addNodeProperty(nodeLabels, propertyKey, propertyValues);
    }

    @Override
    public void removeNodeProperty(String propertyKey) {
        this.graphStore.removeNodeProperty(propertyKey);
    }

    @Override
    public long relationshipCount() {
        return this.graphStore.relationshipCount();
    }

    @Override
    public long relationshipCount(RelationshipType relationshipType) {
        return this.graphStore.relationshipCount(relationshipType);
    }

    @Override
    public Set<RelationshipType> relationshipTypes() {
        return this.graphStore.relationshipTypes();
    }

    @Override
    public boolean hasRelationshipType(RelationshipType relationshipType) {
        return this.graphStore.hasRelationshipType(relationshipType);
    }

    @Override
    public boolean hasRelationshipProperty(RelationshipType relType, String propertyKey) {
        return this.graphStore.hasRelationshipProperty(relType, propertyKey);
    }

    @Override
    public Collection<String> relationshipPropertyKeys(Collection<RelationshipType> relTypes) {
        return this.graphStore.relationshipPropertyKeys(relTypes);
    }

    @Override
    public ValueType relationshipPropertyType(String propertyKey) {
        return this.graphStore.relationshipPropertyType(propertyKey);
    }

    @Override
    public Set<String> relationshipPropertyKeys() {
        return this.graphStore.relationshipPropertyKeys();
    }

    @Override
    public Set<String> relationshipPropertyKeys(RelationshipType relationshipType) {
        return this.graphStore.relationshipPropertyKeys(relationshipType);
    }

    @Override
    public RelationshipProperty relationshipPropertyValues(RelationshipType relationshipType, String propertyKey) {
        return this.graphStore.relationshipPropertyValues(relationshipType, propertyKey);
    }

    @Override
    public void addRelationshipType(RelationshipType relationshipType, Optional<String> relationshipPropertyKey, Optional<NumberType> relationshipPropertyType, Relationships relationships) {
        this.graphStore.addRelationshipType(relationshipType, relationshipPropertyKey, relationshipPropertyType, relationships);
    }

    @Override
    public DeletionResult deleteRelationships(RelationshipType relationshipType) {
        return this.graphStore.deleteRelationships(relationshipType);
    }

    @Override
    public Graph getGraph(NodeLabel nodeLabel) {
        return this.graphStore.getGraph(nodeLabel);
    }

    @Override
    public Graph getGraph(Collection<NodeLabel> nodeLabels) {
        return this.graphStore.getGraph(nodeLabels);
    }

    @Override
    public Graph getGraph(RelationshipType ... relationshipType) {
        return this.graphStore.getGraph(relationshipType);
    }

    @Override
    public Graph getGraph(String relationshipProperty) {
        return this.graphStore.getGraph(relationshipProperty);
    }

    @Override
    public Graph getGraph(RelationshipType relationshipType, Optional<String> relationshipProperty) {
        return this.graphStore.getGraph(relationshipType, relationshipProperty);
    }

    @Override
    public Graph getGraph(Collection<RelationshipType> relationshipTypes, Optional<String> maybeRelationshipProperty) {
        return this.graphStore.getGraph(relationshipTypes, maybeRelationshipProperty);
    }

    @Override
    public Graph getGraph(String nodeLabel, String relationshipType, Optional<String> maybeRelationshipProperty) {
        return this.graphStore.getGraph(nodeLabel, relationshipType, maybeRelationshipProperty);
    }

    @Override
    public Graph getGraph(NodeLabel nodeLabel, RelationshipType relationshipType, Optional<String> maybeRelationshipProperty) {
        return this.graphStore.getGraph(nodeLabel, relationshipType, maybeRelationshipProperty);
    }

    @Override
    public Graph getGraph(Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relationshipTypes, Optional<String> maybeRelationshipProperty) {
        return this.graphStore.getGraph(nodeLabels, relationshipTypes, maybeRelationshipProperty);
    }

    @Override
    public Graph getUnion() {
        return this.graphStore.getUnion();
    }

    @Override
    public CompositeRelationshipIterator getCompositeRelationshipIterator(RelationshipType relationshipType, List<String> propertyKeys) {
        return this.graphStore.getCompositeRelationshipIterator(relationshipType, propertyKeys);
    }

    @Override
    public void canRelease(boolean canRelease) {
        this.graphStore.canRelease(canRelease);
    }

    @Override
    public void release() {
        this.graphStore.release();
    }
}

