/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.CompositeRelationshipIterator;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.RelationshipProperty;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.graph.GraphProperty;
import org.neo4j.gds.api.properties.graph.GraphPropertyValues;
import org.neo4j.gds.api.properties.nodes.NodeProperty;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.core.loading.Capabilities;
import org.neo4j.gds.core.loading.DeletionResult;
import org.neo4j.values.storable.NumberType;

public interface GraphStore {
    public DatabaseId databaseId();

    public GraphSchema schema();

    public ZonedDateTime modificationTime();

    public Capabilities capabilities();

    public Set<String> graphPropertyKeys();

    public boolean hasGraphProperty(String var1);

    public GraphProperty graphProperty(String var1);

    public ValueType graphPropertyType(String var1);

    public GraphPropertyValues graphPropertyValues(String var1);

    public void addGraphProperty(String var1, GraphPropertyValues var2);

    public void removeGraphProperty(String var1);

    public long nodeCount();

    public IdMap nodes();

    public Set<NodeLabel> nodeLabels();

    public Set<String> nodePropertyKeys(NodeLabel var1);

    public Set<String> nodePropertyKeys();

    public boolean hasNodeProperty(String var1);

    public boolean hasNodeProperty(NodeLabel var1, String var2);

    public boolean hasNodeProperty(Collection<NodeLabel> var1, String var2);

    default public Collection<String> nodePropertyKeys(Collection<NodeLabel> labels) {
        if (labels.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<NodeLabel> iterator = labels.iterator();
        HashSet<String> result = new HashSet<String>(this.nodePropertyKeys(iterator.next()));
        while (iterator.hasNext()) {
            result.retainAll(this.nodePropertyKeys(iterator.next()));
        }
        return result;
    }

    public NodeProperty nodeProperty(String var1);

    public void addNodeProperty(Set<NodeLabel> var1, String var2, NodePropertyValues var3);

    public void removeNodeProperty(String var1);

    public long relationshipCount();

    public long relationshipCount(RelationshipType var1);

    public Set<RelationshipType> relationshipTypes();

    public boolean hasRelationshipType(RelationshipType var1);

    public boolean hasRelationshipProperty(RelationshipType var1, String var2);

    default public Collection<String> relationshipPropertyKeys(Collection<RelationshipType> relTypes) {
        if (relTypes.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<RelationshipType> iterator = relTypes.iterator();
        HashSet<String> result = new HashSet<String>(this.relationshipPropertyKeys(iterator.next()));
        while (iterator.hasNext()) {
            result.retainAll(this.relationshipPropertyKeys(iterator.next()));
        }
        return result;
    }

    public ValueType relationshipPropertyType(String var1);

    public Set<String> relationshipPropertyKeys();

    public Set<String> relationshipPropertyKeys(RelationshipType var1);

    public RelationshipProperty relationshipPropertyValues(RelationshipType var1, String var2);

    public void addRelationshipType(RelationshipType var1, Optional<String> var2, Optional<NumberType> var3, Relationships var4);

    public DeletionResult deleteRelationships(RelationshipType var1);

    default public Graph getGraph(RelationshipType ... relationshipType) {
        return this.getGraph(this.nodeLabels(), Arrays.asList(relationshipType), Optional.empty());
    }

    default public Graph getGraph(String relationshipProperty) {
        return this.getGraph(this.nodeLabels(), this.relationshipTypes(), Optional.of(relationshipProperty));
    }

    default public Graph getGraph(RelationshipType relationshipType, Optional<String> relationshipProperty) {
        return this.getGraph(this.nodeLabels(), Collections.singletonList(relationshipType), relationshipProperty);
    }

    default public Graph getGraph(Collection<RelationshipType> relationshipTypes, Optional<String> maybeRelationshipProperty) {
        return this.getGraph(this.nodeLabels(), relationshipTypes, maybeRelationshipProperty);
    }

    default public Graph getGraph(String nodeLabel, String relationshipType, Optional<String> maybeRelationshipProperty) {
        return this.getGraph(NodeLabel.of((String)nodeLabel), RelationshipType.of((String)relationshipType), maybeRelationshipProperty);
    }

    default public Graph getGraph(NodeLabel nodeLabel) {
        return this.getGraph(List.of(nodeLabel));
    }

    public Graph getGraph(Collection<NodeLabel> var1);

    default public Graph getGraph(NodeLabel nodeLabel, RelationshipType relationshipType, Optional<String> maybeRelationshipProperty) {
        return this.getGraph(List.of(nodeLabel), List.of(relationshipType), maybeRelationshipProperty);
    }

    public Graph getGraph(Collection<NodeLabel> var1, Collection<RelationshipType> var2, Optional<String> var3);

    public Graph getUnion();

    public CompositeRelationshipIterator getCompositeRelationshipIterator(RelationshipType var1, List<String> var2);

    public void canRelease(boolean var1);

    public void release();
}

