/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import java.util.concurrent.ExecutorService;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.EmptyTaskRegistryFactory;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.warnings.EmptyUserLogRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

@ValueClass
public interface GraphLoaderContext {
    public static final GraphLoaderContext NULL_CONTEXT = new GraphLoaderContext(){

        @Override
        public TransactionContext transactionContext() {
            return null;
        }

        @Override
        public GraphDatabaseService graphDatabaseService() {
            return null;
        }

        @Override
        public Log log() {
            return NullLog.getInstance();
        }

        @Override
        public TaskRegistryFactory taskRegistryFactory() {
            return EmptyTaskRegistryFactory.INSTANCE;
        }

        @Override
        public UserLogRegistryFactory userLogRegistryFactory() {
            return EmptyUserLogRegistryFactory.INSTANCE;
        }
    };

    public TransactionContext transactionContext();

    public GraphDatabaseService graphDatabaseService();

    public Log log();

    @Value.Default
    default public ExecutorService executor() {
        return Pools.DEFAULT;
    }

    @Value.Default
    default public TerminationFlag terminationFlag() {
        return TerminationFlag.RUNNING_TRUE;
    }

    public TaskRegistryFactory taskRegistryFactory();

    public UserLogRegistryFactory userLogRegistryFactory();
}

