/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.LongPredicate;
import java.util.stream.Stream;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.FilteredIdMap;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.RelationshipConsumer;
import org.neo4j.gds.api.RelationshipCursor;
import org.neo4j.gds.api.RelationshipWithPropertyConsumer;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.core.huge.NodeFilteredGraph;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongIterable;

public abstract class GraphAdapter
implements Graph {
    protected final Graph graph;

    public GraphAdapter(Graph graph) {
        this.graph = graph;
    }

    public Graph graph() {
        return this.graph;
    }

    @Override
    public long relationshipCount() {
        return this.graph.relationshipCount();
    }

    @Override
    public boolean hasRelationshipProperty() {
        return this.graph.hasRelationshipProperty();
    }

    @Override
    public void canRelease(boolean canRelease) {
        this.graph.canRelease(canRelease);
    }

    @Override
    public Optional<NodeFilteredGraph> asNodeFilteredGraph() {
        return this.graph.asNodeFilteredGraph();
    }

    @Override
    public Collection<PrimitiveLongIterable> batchIterables(long batchSize) {
        return this.graph.batchIterables(batchSize);
    }

    @Override
    public int degree(long nodeId) {
        return this.graph.degree(nodeId);
    }

    @Override
    public int degreeWithoutParallelRelationships(long nodeId) {
        return this.graph.degreeWithoutParallelRelationships(nodeId);
    }

    @Override
    public long toMappedNodeId(long originalNodeId) {
        return this.graph.toMappedNodeId(originalNodeId);
    }

    @Override
    public long toOriginalNodeId(long mappedNodeId) {
        return this.graph.toOriginalNodeId(mappedNodeId);
    }

    @Override
    public long toRootNodeId(long mappedNodeId) {
        return this.graph.toRootNodeId(mappedNodeId);
    }

    @Override
    public IdMap rootIdMap() {
        return this.graph.rootIdMap();
    }

    @Override
    public boolean contains(long originalNodeId) {
        return this.graph.contains(originalNodeId);
    }

    @Override
    public long nodeCount() {
        return this.graph.nodeCount();
    }

    @Override
    public OptionalLong rootNodeCount() {
        return this.graph.rootNodeCount();
    }

    @Override
    public long highestNeoId() {
        return this.graph.highestNeoId();
    }

    @Override
    public void forEachNode(LongPredicate consumer) {
        this.graph.forEachNode(consumer);
    }

    @Override
    public PrimitiveIterator.OfLong nodeIterator() {
        return this.graph.nodeIterator();
    }

    @Override
    public PrimitiveIterator.OfLong nodeIterator(Set<NodeLabel> labels) {
        return this.graph.nodeIterator(labels);
    }

    @Override
    public GraphSchema schema() {
        return this.graph.schema();
    }

    @Override
    public List<NodeLabel> nodeLabels(long mappedNodeId) {
        return this.graph.nodeLabels(mappedNodeId);
    }

    @Override
    public void forEachNodeLabel(long mappedNodeId, IdMap.NodeLabelConsumer consumer) {
        this.graph.forEachNodeLabel(mappedNodeId, consumer);
    }

    @Override
    public Set<NodeLabel> availableNodeLabels() {
        return this.graph.availableNodeLabels();
    }

    @Override
    public boolean hasLabel(long mappedNodeId, NodeLabel label) {
        return this.graph.hasLabel(mappedNodeId, label);
    }

    @Override
    public Optional<? extends FilteredIdMap> withFilteredLabels(Collection<NodeLabel> nodeLabels, int concurrency) {
        return this.graph.withFilteredLabels(nodeLabels, concurrency);
    }

    @Override
    public NodePropertyValues nodeProperties(String propertyKey) {
        return this.graph.nodeProperties(propertyKey);
    }

    @Override
    public Set<String> availableNodeProperties() {
        return this.graph.availableNodeProperties();
    }

    @Override
    public void forEachRelationship(long nodeId, RelationshipConsumer consumer) {
        this.graph.forEachRelationship(nodeId, consumer);
    }

    @Override
    public void forEachRelationship(long nodeId, double fallbackValue, RelationshipWithPropertyConsumer consumer) {
        this.graph.forEachRelationship(nodeId, fallbackValue, consumer);
    }

    @Override
    public Stream<RelationshipCursor> streamRelationships(long nodeId, double fallbackValue) {
        return this.graph.streamRelationships(nodeId, fallbackValue);
    }

    @Override
    public Graph relationshipTypeFilteredGraph(Set<RelationshipType> relationshipTypes) {
        return this.graph.relationshipTypeFilteredGraph(relationshipTypes);
    }

    @Override
    public boolean exists(long sourceNodeId, long targetNodeId) {
        return this.graph.exists(sourceNodeId, targetNodeId);
    }

    @Override
    public long nthTarget(long nodeId, int offset) {
        return this.graph.nthTarget(nodeId, offset);
    }

    @Override
    public double relationshipProperty(long sourceNodeId, long targetNodeId, double fallbackValue) {
        return this.graph.relationshipProperty(sourceNodeId, targetNodeId, fallbackValue);
    }

    @Override
    public double relationshipProperty(long sourceNodeId, long targetNodeId) {
        return this.graph.relationshipProperty(sourceNodeId, targetNodeId);
    }

    @Override
    public void release() {
        this.graph.release();
    }

    @Override
    public void releaseTopology() {
        this.graph.releaseTopology();
    }

    @Override
    public void releaseProperties() {
        this.graph.releaseProperties();
    }

    @Override
    public boolean isMultiGraph() {
        return this.graph.isMultiGraph();
    }
}

