/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import java.util.Set;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Degrees;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.RelationshipConsumer;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.api.RelationshipProperties;
import org.neo4j.gds.api.properties.nodes.NodePropertyContainer;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.core.huge.NodeFilteredGraph;

@SuppressFBWarnings(value={"UCF_USELESS_CONTROL_FLOW"})
public interface Graph
extends IdMap,
NodePropertyContainer,
Degrees,
RelationshipIterator,
RelationshipProperties {
    public GraphSchema schema();

    default public boolean isEmpty() {
        return this.nodeCount() == 0L;
    }

    public long relationshipCount();

    default public void release() {
        this.releaseTopology();
        this.releaseProperties();
    }

    default public void releaseTopology() {
    }

    default public void releaseProperties() {
    }

    public boolean isMultiGraph();

    public Graph relationshipTypeFilteredGraph(Set<RelationshipType> var1);

    public boolean hasRelationshipProperty();

    public void canRelease(boolean var1);

    @Override
    public Graph concurrentCopy();

    public Optional<NodeFilteredGraph> asNodeFilteredGraph();

    default public long nthTarget(long sourceNodeId, int offset) {
        return Graph.nthTarget(this, sourceNodeId, offset);
    }

    public static long nthTarget(Graph graph, long sourceNodeId, int offset) {
        if (offset >= graph.degree(sourceNodeId)) {
            return -1L;
        }
        if (!1.$assertionsDisabled && offset < 0) {
            throw new AssertionError((Object)("offset must be positive, got " + offset));
        }
        class FindNth
        implements RelationshipConsumer {
            private int remaining;
            private long target;
            final /* synthetic */ int val$offset;

            FindNth(int n) {
                this.val$offset = n;
                this.remaining = this.val$offset;
                this.target = -1L;
            }

            @Override
            public boolean accept(long sourceNodeId, long targetNodeId) {
                if (this.remaining-- == 0) {
                    this.target = targetNodeId;
                    return false;
                }
                return true;
            }
        }
        FindNth findN = new FindNth(offset);
        graph.forEachRelationship(sourceNodeId, findN);
        return findN.target;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

