/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import java.util.Objects;
import java.util.UUID;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.GraphDatabaseService;

public final class DatabaseId {
    private final String databaseName;

    public static DatabaseId of(GraphDatabaseService databaseService) {
        return new DatabaseId(DatabaseId.normalizeDatabseName(databaseService.databaseName()));
    }

    public static DatabaseId from(String databaseName) {
        return new DatabaseId(DatabaseId.normalizeDatabseName(databaseName));
    }

    public static DatabaseId random() {
        return DatabaseId.from(DatabaseId.normalizeDatabseName(UUID.randomUUID().toString()));
    }

    private static String normalizeDatabseName(String databaseName) {
        Objects.requireNonNull(databaseName, "Database name should be not null.");
        return StringFormatting.toLowerCaseWithLocale((String)databaseName);
    }

    public String databaseName() {
        return this.databaseName;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DatabaseId && this.equalTo((DatabaseId)another);
    }

    private boolean equalTo(DatabaseId another) {
        return this.databaseName.equals(another.databaseName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.databaseName.hashCode();
        return h;
    }

    public String toString() {
        return "DatabaseId{databaseName=" + this.databaseName + "}";
    }

    private DatabaseId(String databaseName) {
        this.databaseName = databaseName;
    }
}

