/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.GraphStoreFactory;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.loading.CSRGraphStore;
import org.neo4j.gds.core.loading.Capabilities;
import org.neo4j.gds.core.loading.GraphStoreBuilder;
import org.neo4j.gds.core.loading.IdMapAndProperties;
import org.neo4j.gds.core.loading.RelationshipsAndProperties;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.utils.StringFormatting;

public abstract class CSRGraphStoreFactory<CONFIG extends GraphProjectConfig>
extends GraphStoreFactory<CSRGraphStore, CONFIG> {
    public CSRGraphStoreFactory(CONFIG graphProjectConfig, Capabilities capabilities, GraphLoaderContext loadingContext, GraphDimensions dimensions) {
        super(graphProjectConfig, capabilities, loadingContext, dimensions);
    }

    protected CSRGraphStore createGraphStore(IdMapAndProperties idMapAndProperties, RelationshipsAndProperties relationshipsAndProperties) {
        return new GraphStoreBuilder().databaseId(DatabaseId.of(this.loadingContext.graphDatabaseService())).capabilities(this.capabilities).schema(this.computeGraphSchema(idMapAndProperties, relationshipsAndProperties)).nodes(idMapAndProperties.idMap()).nodePropertyStore(idMapAndProperties.properties()).relationships(relationshipsAndProperties.relationships()).relationshipPropertyStores(relationshipsAndProperties.properties()).concurrency(this.graphProjectConfig.readConcurrency()).build();
    }

    protected void logLoadingSummary(GraphStore graphStore) {
        long sizeInBytes = MemoryUsage.sizeOf((Object)graphStore);
        String memoryUsage = MemoryUsage.humanReadable((long)sizeInBytes);
        this.progressTracker.logInfo(StringFormatting.formatWithLocale((String)"Actual memory usage of the loaded graph: %s", (Object[])new Object[]{memoryUsage}));
    }

    protected abstract GraphSchema computeGraphSchema(IdMapAndProperties var1, RelationshipsAndProperties var2);
}

