/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import com.carrotsearch.hppc.BitSet;
import java.util.Collection;
import java.util.PrimitiveIterator;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongIterable;

public interface BatchNodeIterable {
    public Collection<PrimitiveLongIterable> batchIterables(long var1);

    public static final class BitSetIdIterator
    implements PrimitiveIterator.OfLong {
        private final BitSet labelBitSet;
        long position;

        public BitSetIdIterator(BitSet labelBitSet) {
            this.labelBitSet = labelBitSet;
            this.position = labelBitSet.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.position >= 0L;
        }

        @Override
        public long nextLong() {
            long tmp = this.position;
            this.position = this.labelBitSet.nextSetBit(this.position + 1L);
            return tmp;
        }
    }

    public static final class IdIterator
    implements PrimitiveIterator.OfLong {
        private long current;
        private final long limit;

        public IdIterator(long length) {
            this.current = 0L;
            this.limit = length;
        }

        private IdIterator(long start, long length) {
            this.current = start;
            this.limit = start + length;
        }

        @Override
        public boolean hasNext() {
            return this.current < this.limit;
        }

        @Override
        public long nextLong() {
            return this.current++;
        }
    }

    public static final class IdIterable
    implements PrimitiveLongIterable {
        private final long start;
        private final long length;

        public IdIterable(long start, long length) {
            this.start = start;
            this.length = length;
        }

        @Override
        public PrimitiveIterator.OfLong iterator() {
            return new IdIterator(this.start, this.length);
        }
    }
}

