/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AdjacencyCursor
extends AutoCloseable {
    public static final long NOT_FOUND = -1L;

    public void init(long var1, int var3);

    public int size();

    public boolean hasNextVLong();

    public long nextVLong();

    public long peekVLong();

    public int remaining();

    public long skipUntil(long var1);

    public long advance(long var1);

    public long advanceBy(int var1);

    @NotNull
    public AdjacencyCursor shallowCopy(@Nullable AdjacencyCursor var1);

    @Override
    public void close();

    public static AdjacencyCursor empty() {
        return EmptyAdjacencyCursor.INSTANCE;
    }

    public static enum EmptyAdjacencyCursor implements AdjacencyCursor
    {
        INSTANCE;


        @Override
        public void init(long index, int degree) {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean hasNextVLong() {
            return false;
        }

        @Override
        public long nextVLong() {
            return -1L;
        }

        @Override
        public long peekVLong() {
            return -1L;
        }

        @Override
        public int remaining() {
            return 0;
        }

        @Override
        public long skipUntil(long nodeId) {
            return -1L;
        }

        @Override
        public long advance(long nodeId) {
            return -1L;
        }

        @Override
        public long advanceBy(int n) {
            return -1L;
        }

        @Override
        @NotNull
        public AdjacencyCursor shallowCopy(@Nullable AdjacencyCursor destination) {
            return INSTANCE;
        }

        @Override
        public void close() {
        }
    }
}

