/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.gds.core.write;

import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;

import java.util.Collection;

public interface NodePropertyExporter {

    long MIN_BATCH_SIZE = 10_000L;
    long MAX_BATCH_SIZE = 100_000L;

    void write(String property, NodePropertyValues properties);

    void write(NodeProperty nodeProperty);

    void write(Collection<NodeProperty> nodeProperties);

    long propertiesWritten();

    static Task baseTask(String operationName, long taskVolume) {
        return Tasks.leaf(operationName + " :: WriteNodeProperties", taskVolume);
    }

    static Task innerTask(String innerName, long taskVolume) {
        return Tasks.leaf(innerName, taskVolume);
    }
}
