/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.gds.core.utils;

import java.util.concurrent.TimeUnit;
import java.util.function.LongConsumer;

public class ProgressTimer implements AutoCloseable {

    private final LongConsumer onStop;
    private final long startTime;
    private long duration = 0;

    private ProgressTimer(LongConsumer onStop) {
        this.onStop = onStop == null ? l -> {} : onStop;
        startTime = System.nanoTime();
    }

    public ProgressTimer stop() {
        duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        onStop.accept(duration);
        return this;
    }

    public long getDuration() {
        return duration;
    }

    public static ProgressTimer start(LongConsumer onStop) {
        return new ProgressTimer(onStop);
    }

    public static ProgressTimer start() {
        return new ProgressTimer(null);
    }

    @Override
    public void close() {
        stop();
    }
}
