/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.gds.api.properties.graph;

import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.properties.PropertyStore;

import java.util.Collections;

@ValueClass
public interface GraphPropertyStore extends PropertyStore<GraphPropertyValues, GraphProperty> {

    static GraphPropertyStore empty() {
        return ImmutableGraphPropertyStore.of(Collections.emptyMap());
    }

    static Builder builder() {
        // need to initialize with empty map due to `deferCollectionAllocation = true`
        return new Builder().properties(Collections.emptyMap());
    }

    @org.immutables.builder.Builder.AccessibleFields
    final class Builder extends ImmutableGraphPropertyStore.Builder {

        public Builder putIfAbsent(String propertyKey, GraphProperty graphProperty) {
            properties.putIfAbsent(propertyKey, graphProperty);
            return this;
        }

        public Builder removeProperty(String propertyKey) {
            properties.remove(propertyKey);
            return this;
        }
    }
}
