/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write.resultstore;

import java.util.function.LongUnaryOperator;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.RelationshipWithPropertyConsumer;
import org.neo4j.gds.api.ResultStore;
import org.neo4j.gds.core.write.RelationshipExporter;

public class ResultStoreRelationshipExporter
implements RelationshipExporter {
    private final ResultStore resultStore;
    private final Graph graph;
    private final LongUnaryOperator toOriginalId;

    ResultStoreRelationshipExporter(ResultStore resultStore, Graph graph, LongUnaryOperator toOriginalId) {
        this.resultStore = resultStore;
        this.graph = graph;
        this.toOriginalId = toOriginalId;
    }

    @Override
    public void write(String relationshipType) {
        this.resultStore.addRelationship(relationshipType, this.graph, this.toOriginalId);
    }

    @Override
    public void write(String relationshipType, String propertyKey) {
        this.write(relationshipType, propertyKey, null);
    }

    @Override
    public void write(String relationshipType, String propertyKey, @Nullable RelationshipWithPropertyConsumer afterWriteConsumer) {
        this.resultStore.addRelationship(relationshipType, propertyKey, this.graph, this.toOriginalId);
    }
}

