/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write.resultstore;

import java.util.Collection;
import java.util.List;
import org.neo4j.gds.api.ResultStore;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.write.ImmutableNodeProperty;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.core.write.NodePropertyExporter;

public class ResultStoreNodePropertyExporter
implements NodePropertyExporter {
    private final ResultStore resultStore;
    private long writtenProperties;

    ResultStoreNodePropertyExporter(ResultStore resultStore) {
        this.resultStore = resultStore;
    }

    @Override
    public void write(String property, NodePropertyValues properties) {
        this.write(ImmutableNodeProperty.of(property, properties));
    }

    @Override
    public void write(NodeProperty nodeProperty) {
        this.write(List.of(nodeProperty));
    }

    @Override
    public void write(Collection<NodeProperty> nodeProperties) {
        nodeProperties.forEach(nodeProperty -> {
            NodePropertyValues propertyValues = nodeProperty.properties();
            this.resultStore.addNodePropertyValues(nodeProperty.propertyKey(), propertyValues);
            this.writtenProperties += propertyValues.nodeCount();
        });
    }

    @Override
    public long propertiesWritten() {
        return this.writtenProperties;
    }
}

