/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write.resultstore;

import java.util.function.LongUnaryOperator;
import java.util.stream.LongStream;
import org.neo4j.gds.api.ResultStore;
import org.neo4j.gds.core.write.NodeLabelExporter;

public class ResultStoreNodeLabelExporter
implements NodeLabelExporter {
    private final ResultStore resultStore;
    private final long nodeCount;
    private final LongUnaryOperator toOriginalId;

    ResultStoreNodeLabelExporter(ResultStore resultStore, long nodeCount, LongUnaryOperator toOriginalId) {
        this.resultStore = resultStore;
        this.nodeCount = nodeCount;
        this.toOriginalId = toOriginalId;
    }

    @Override
    public void write(String nodeLabel) {
        this.resultStore.addNodeLabel(nodeLabel, LongStream.range(0L, this.nodeCount).map(this.toOriginalId).iterator());
    }

    @Override
    public long nodeLabelsWritten() {
        return this.nodeCount;
    }
}

