/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write;

import java.util.Optional;
import java.util.function.LongUnaryOperator;
import java.util.stream.Stream;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.api.ExportedRelationship;
import org.neo4j.gds.api.ResultStore;
import org.neo4j.gds.config.ArrowConnectionInfo;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.write.RelationshipStreamExporter;
import org.neo4j.gds.termination.TerminationFlag;

public abstract class RelationshipStreamExporterBuilder {
    protected Stream<ExportedRelationship> relationships;
    protected int batchSize = 10000;
    protected LongUnaryOperator toOriginalId;
    protected TerminationFlag terminationFlag;
    protected ProgressTracker progressTracker = ProgressTracker.NULL_TRACKER;
    protected long relationshipCount = -1L;
    protected int concurrency = Runtime.getRuntime().availableProcessors();
    protected Optional<ArrowConnectionInfo> arrowConnectionInfo;
    protected Optional<String> remoteDatabaseName;
    protected Optional<ResultStore> resultStore;

    public abstract RelationshipStreamExporter build();

    public RelationshipStreamExporterBuilder withIdMappingOperator(LongUnaryOperator toOriginalNodeId) {
        this.toOriginalId = toOriginalNodeId;
        return this;
    }

    public RelationshipStreamExporterBuilder withTerminationFlag(TerminationFlag terminationFlag) {
        this.terminationFlag = terminationFlag;
        return this;
    }

    public RelationshipStreamExporterBuilder withRelationships(Stream<ExportedRelationship> relationships) {
        this.relationships = relationships;
        return this;
    }

    public RelationshipStreamExporterBuilder withRelationshipCount(long relationshipCount) {
        this.relationshipCount = relationshipCount;
        return this;
    }

    @TestOnly
    public RelationshipStreamExporterBuilder withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public RelationshipStreamExporterBuilder withProgressTracker(ProgressTracker progressTracker) {
        this.progressTracker = progressTracker;
        return this;
    }

    public RelationshipStreamExporterBuilder withArrowConnectionInfo(Optional<ArrowConnectionInfo> arrowConnectionInfo, Optional<String> remoteDatabaseName) {
        this.arrowConnectionInfo = arrowConnectionInfo;
        this.remoteDatabaseName = remoteDatabaseName;
        return this;
    }

    public RelationshipStreamExporterBuilder withConcurrency(int concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public RelationshipStreamExporterBuilder withResultStore(Optional<ResultStore> resultStore) {
        this.resultStore = resultStore;
        return this;
    }
}

