/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write;

import java.util.Optional;
import java.util.function.LongUnaryOperator;
import java.util.stream.Stream;
import org.neo4j.gds.api.ExportedRelationship;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.ResultStore;
import org.neo4j.gds.config.ArrowConnectionInfo;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.write.RelationshipPropertiesExporter;
import org.neo4j.gds.core.write.RelationshipPropertyTranslator;
import org.neo4j.gds.termination.TerminationFlag;
import org.neo4j.values.storable.Values;

public abstract class RelationshipPropertiesExporterBuilder {
    protected TerminationFlag terminationFlag;
    protected GraphStore graphStore;
    protected ProgressTracker progressTracker = ProgressTracker.NULL_TRACKER;
    protected RelationshipPropertyTranslator propertyTranslator = Values::doubleValue;
    protected Stream<ExportedRelationship> relationships;
    protected LongUnaryOperator toOriginalId;
    protected long relationshipCount = -1L;
    protected int concurrency = Runtime.getRuntime().availableProcessors();
    protected long batchSize = 10000L;
    protected Optional<ArrowConnectionInfo> arrowConnectionInfo;
    protected Optional<String> remoteDatabaseName;
    protected Optional<ResultStore> resultStore;

    public abstract RelationshipPropertiesExporter build();

    public RelationshipPropertiesExporterBuilder withGraphStore(GraphStore graphStore) {
        this.graphStore = graphStore;
        return this;
    }

    public RelationshipPropertiesExporterBuilder withRelationPropertyTranslator(RelationshipPropertyTranslator propertyTranslator) {
        this.propertyTranslator = propertyTranslator;
        return this;
    }

    public RelationshipPropertiesExporterBuilder withTerminationFlag(TerminationFlag terminationFlag) {
        this.terminationFlag = terminationFlag;
        return this;
    }

    public RelationshipPropertiesExporterBuilder withProgressTracker(ProgressTracker progressTracker) {
        this.progressTracker = progressTracker;
        return this;
    }

    public RelationshipPropertiesExporterBuilder withIdMappingOperator(LongUnaryOperator toOriginalNodeId) {
        this.toOriginalId = toOriginalNodeId;
        return this;
    }

    public RelationshipPropertiesExporterBuilder withRelationships(Stream<ExportedRelationship> relationships) {
        this.relationships = relationships;
        return this;
    }

    public RelationshipPropertiesExporterBuilder withRelationshipCount(long relationshipCount) {
        this.relationshipCount = relationshipCount;
        return this;
    }

    public RelationshipPropertiesExporterBuilder withArrowConnectionInfo(Optional<ArrowConnectionInfo> arrowConnectionInfo, Optional<String> remoteDatabaseName) {
        this.arrowConnectionInfo = arrowConnectionInfo;
        this.remoteDatabaseName = remoteDatabaseName;
        return this;
    }

    public RelationshipPropertiesExporterBuilder withConcurrency(int concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public RelationshipPropertiesExporterBuilder withBatchSize(long batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public RelationshipPropertiesExporterBuilder withResultStore(Optional<ResultStore> resultStore) {
        this.resultStore = resultStore;
        return this;
    }
}

