/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write;

import java.util.Optional;
import java.util.function.LongUnaryOperator;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.ResultStore;
import org.neo4j.gds.config.ArrowConnectionInfo;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.write.RelationshipExporter;
import org.neo4j.gds.core.write.RelationshipPropertyTranslator;
import org.neo4j.gds.termination.TerminationFlag;
import org.neo4j.values.storable.Values;

public abstract class RelationshipExporterBuilder {
    public static final int DEFAULT_WRITE_CONCURRENCY = 1;
    protected LongUnaryOperator toOriginalId;
    protected TerminationFlag terminationFlag;
    protected Graph graph;
    protected ProgressTracker progressTracker = ProgressTracker.NULL_TRACKER;
    protected RelationshipPropertyTranslator propertyTranslator = Values::doubleValue;
    protected Optional<ArrowConnectionInfo> arrowConnectionInfo = Optional.empty();
    protected int concurrency = Runtime.getRuntime().availableProcessors();
    protected long batchSize = 10000L;
    protected Optional<String> remoteDatabaseName;
    protected Optional<ResultStore> resultStore;

    public abstract RelationshipExporter build();

    public RelationshipExporterBuilder withRelationPropertyTranslator(RelationshipPropertyTranslator propertyTranslator) {
        this.propertyTranslator = propertyTranslator;
        return this;
    }

    public RelationshipExporterBuilder withGraph(Graph graph) {
        this.graph = graph;
        return this;
    }

    public RelationshipExporterBuilder withIdMappingOperator(LongUnaryOperator toOriginalId) {
        this.toOriginalId = toOriginalId;
        return this;
    }

    public RelationshipExporterBuilder withTerminationFlag(TerminationFlag terminationFlag) {
        this.terminationFlag = terminationFlag;
        return this;
    }

    public RelationshipExporterBuilder withProgressTracker(ProgressTracker progressTracker) {
        this.progressTracker = progressTracker;
        return this;
    }

    public RelationshipExporterBuilder withArrowConnectionInfo(Optional<ArrowConnectionInfo> arrowConnectionInfo, Optional<String> remoteDatabaseName) {
        this.remoteDatabaseName = remoteDatabaseName;
        this.arrowConnectionInfo = arrowConnectionInfo;
        return this;
    }

    public RelationshipExporterBuilder withConcurrency(int concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public RelationshipExporterBuilder withBatchSize(long batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public RelationshipExporterBuilder withResultStore(Optional<ResultStore> resultStore) {
        this.resultStore = resultStore;
        return this;
    }
}

