/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.LongUnaryOperator;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.ResultStore;
import org.neo4j.gds.config.ArrowConnectionInfo;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.termination.TerminationFlag;

public abstract class NodePropertyExporterBuilder {
    protected LongUnaryOperator toOriginalId;
    protected long nodeCount;
    protected TerminationFlag terminationFlag;
    protected ExecutorService executorService;
    protected int writeConcurrency = 4;
    protected ProgressTracker progressTracker = ProgressTracker.NULL_TRACKER;
    protected Optional<ArrowConnectionInfo> arrowConnectionInfo = Optional.empty();
    protected Optional<String> remoteDatabaseName;
    protected Optional<ResultStore> resultStore = Optional.empty();

    public abstract NodePropertyExporter build();

    public NodePropertyExporterBuilder withIdMap(IdMap idMap) {
        Objects.requireNonNull(idMap);
        this.nodeCount = idMap.nodeCount();
        this.toOriginalId = arg_0 -> ((IdMap)idMap).toOriginalNodeId(arg_0);
        return this;
    }

    public NodePropertyExporterBuilder withTerminationFlag(TerminationFlag terminationFlag) {
        this.terminationFlag = terminationFlag;
        return this;
    }

    public NodePropertyExporterBuilder withProgressTracker(ProgressTracker progressTracker) {
        this.progressTracker = progressTracker;
        return this;
    }

    public NodePropertyExporterBuilder withArrowConnectionInfo(Optional<ArrowConnectionInfo> arrowConnectionInfo, Optional<String> remoteDatabaseName) {
        this.arrowConnectionInfo = arrowConnectionInfo;
        this.remoteDatabaseName = remoteDatabaseName;
        return this;
    }

    public NodePropertyExporterBuilder parallel(ExecutorService es, int writeConcurrency) {
        this.executorService = es;
        this.writeConcurrency = writeConcurrency;
        return this;
    }

    public NodePropertyExporterBuilder withResultStore(Optional<ResultStore> resultStore) {
        this.resultStore = resultStore;
        return this;
    }
}

