/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.gds.api.ExportedRelationship;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.core.concurrency.DefaultPool;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.write.NativeRelationshipStreamExporterBuilder;
import org.neo4j.gds.core.write.RelationshipStreamExporter;
import org.neo4j.gds.core.write.RelationshipStreamExporterBuilder;
import org.neo4j.gds.termination.TerminationFlag;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.gds.utils.StatementApi;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.values.storable.Value;

public final class NativeRelationshipStreamExporter
extends StatementApi
implements RelationshipStreamExporter {
    private static final int QUEUE_CAPACITY = 2;
    private final LongUnaryOperator toOriginalId;
    private final Stream<ExportedRelationship> relationships;
    private final int batchSize;
    private final int concurrency;
    private final TerminationFlag terminationFlag;
    private final ProgressTracker progressTracker;

    public static RelationshipStreamExporterBuilder builder(TransactionContext transactionContext, IdMap idMap, Stream<ExportedRelationship> relationships, TerminationFlag terminationFlag) {
        return new NativeRelationshipStreamExporterBuilder(transactionContext).withRelationships(relationships).withIdMappingOperator(arg_0 -> ((IdMap)idMap).toOriginalNodeId(arg_0)).withTerminationFlag(terminationFlag);
    }

    NativeRelationshipStreamExporter(TransactionContext tx, LongUnaryOperator toOriginalId, Stream<ExportedRelationship> relationships, int batchSize, int concurrency, TerminationFlag terminationFlag, ProgressTracker progressTracker) {
        super(tx);
        this.toOriginalId = toOriginalId;
        this.relationships = (Stream)relationships.sequential();
        this.batchSize = batchSize;
        this.concurrency = concurrency;
        this.terminationFlag = terminationFlag;
        this.progressTracker = progressTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(String relationshipType, List<String> propertyKeys, List<ValueType> __) {
        this.progressTracker.beginSubTask();
        LongAdder written = new LongAdder();
        try {
            int relationshipToken = this.getOrCreateRelationshipToken(relationshipType);
            int[] propertyTokens = propertyKeys.stream().mapToInt(x$0 -> this.getOrCreatePropertyToken((String)x$0)).toArray();
            LinkedBlockingQueue<Buffer> writeQueue = new LinkedBlockingQueue<Buffer>(this.concurrency * 2);
            LinkedBlockingQueue<Buffer> bufferPool = new LinkedBlockingQueue<Buffer>(this.concurrency * 2);
            for (int i2 = 0; i2 < this.concurrency * 2; ++i2) {
                bufferPool.add(new Buffer(this.batchSize));
            }
            ExecutorService executor = DefaultPool.INSTANCE;
            List writerFutures = IntStream.range(0, this.concurrency).mapToObj(i -> new Writer(this.tx, this.progressTracker, this.toOriginalId, writeQueue, bufferPool, relationshipToken, propertyTokens, written, this.terminationFlag)).map(executor::submit).collect(Collectors.toList());
            AtomicReference<Buffer> bufferRef = new AtomicReference<Buffer>((Buffer)bufferPool.poll());
            this.relationships.forEach(relationship -> {
                Buffer buffer = (Buffer)bufferRef.get();
                buffer.add((ExportedRelationship)relationship);
                if (buffer.isFull()) {
                    try {
                        writeQueue.put(buffer);
                        bufferRef.set((Buffer)bufferPool.take());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                }
            });
            try {
                writeQueue.put(bufferRef.get());
                for (int i3 = 0; i3 < this.concurrency; ++i3) {
                    writeQueue.put(new Buffer(0));
                }
                for (Future writerFuture : writerFutures) {
                    writerFuture.get();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            long l = written.longValue();
            return l;
        }
        finally {
            this.progressTracker.endSubTask();
        }
    }

    static class Buffer {
        private final long capacity;
        private final ExportedRelationship[] relationships;
        private int size;

        Buffer(int capacity) {
            this.relationships = new ExportedRelationship[capacity];
            this.capacity = capacity;
        }

        void add(ExportedRelationship relationship) {
            this.relationships[this.size] = relationship;
            ++this.size;
        }

        boolean isFull() {
            return (long)this.size == this.capacity;
        }

        void reset() {
            this.size = 0;
        }
    }

    static class Writer
    extends StatementApi
    implements Runnable {
        private final TerminationFlag terminationFlag;
        private final ProgressTracker progressTracker;
        private final LongUnaryOperator toOriginalId;
        private final BlockingQueue<Buffer> writeQueue;
        private final BlockingQueue<Buffer> bufferPool;
        private final int relationshipToken;
        private final int[] propertyTokens;
        private final LongAdder written;

        Writer(TransactionContext tx, ProgressTracker progressTracker, LongUnaryOperator toOriginalId, BlockingQueue<Buffer> writeQueue, BlockingQueue<Buffer> bufferPool, int relationshipToken, int[] propertyTokens, LongAdder written, TerminationFlag terminationFlag) {
            super(tx);
            this.progressTracker = progressTracker;
            this.toOriginalId = toOriginalId;
            this.writeQueue = writeQueue;
            this.bufferPool = bufferPool;
            this.relationshipToken = relationshipToken;
            this.propertyTokens = propertyTokens;
            this.terminationFlag = terminationFlag;
            this.written = written;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Buffer buffer = this.writeQueue.take();
                    if (buffer.size == 0) {
                        return;
                    }
                    this.written.add(this.write(buffer, this.relationshipToken, this.propertyTokens));
                    this.progressTracker.logProgress(this.written.longValue(), "has written %d relationships");
                    buffer.reset();
                    this.bufferPool.put(buffer);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }

        private int write(Buffer buffer, int relationshipToken, int[] propertyTokens) {
            int bufferSize = buffer.size;
            int tokenCount = propertyTokens.length;
            ExportedRelationship[] relationships = buffer.relationships;
            this.acceptInTransaction(stmt -> {
                this.terminationFlag.assertRunning();
                Write ops = stmt.dataWrite();
                for (int i = 0; i < bufferSize; ++i) {
                    long relationshipId = ops.relationshipCreate(this.toOriginalId.applyAsLong(relationships[i].sourceNode()), relationshipToken, this.toOriginalId.applyAsLong(relationships[i].targetNode()));
                    Value[] values = relationships[i].values();
                    for (int j = 0; j < tokenCount; ++j) {
                        ops.relationshipSetProperty(relationshipId, propertyTokens[j], values[j]);
                    }
                }
            });
            return bufferSize;
        }
    }
}

