/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collectors;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.CompositeRelationshipIterator;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.concurrency.DefaultPool;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.partition.DegreePartition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.write.RelationshipPropertiesExporter;
import org.neo4j.gds.core.write.RelationshipPropertyTranslator;
import org.neo4j.gds.termination.TerminationFlag;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.gds.utils.ExceptionUtil;
import org.neo4j.gds.utils.StatementApi;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;

public class NativeRelationshipPropertiesExporter
extends StatementApi
implements RelationshipPropertiesExporter {
    private final GraphStore graphStore;
    private final RelationshipPropertyTranslator propertyTranslator;
    private final ProgressTracker progressTracker;
    private final int concurrency;
    private final long batchSize;
    private final TerminationFlag terminationFlag;

    NativeRelationshipPropertiesExporter(TransactionContext tx, GraphStore graphStore, RelationshipPropertyTranslator propertyTranslator, int concurrency, long batchSize, ProgressTracker progressTracker, TerminationFlag terminationFlag) {
        super(tx);
        this.graphStore = graphStore;
        this.propertyTranslator = propertyTranslator;
        this.concurrency = concurrency;
        this.batchSize = batchSize;
        this.progressTracker = progressTracker;
        this.terminationFlag = terminationFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String relationshipType, List<String> propertyKeys) {
        Graph graph = this.graphStore.getGraph(new RelationshipType[]{RelationshipType.of((String)relationshipType)});
        int relationshipToken = this.getOrCreateRelationshipToken(relationshipType);
        List propertyTokens = propertyKeys.stream().map(x$0 -> this.getOrCreatePropertyToken((String)x$0)).collect(Collectors.toList());
        CompositeRelationshipIterator relationshipIterator = this.graphStore.getCompositeRelationshipIterator(RelationshipType.of((String)relationshipType), propertyKeys);
        List tasks = PartitionUtils.degreePartitionWithBatchSize((Graph)graph, (long)this.batchSize, partition -> this.createBatchRunnable(relationshipToken, propertyTokens, (DegreePartition)partition, relationshipIterator.concurrentCopy(), arg_0 -> ((Graph)graph).toOriginalNodeId(arg_0)));
        this.progressTracker.beginSubTask();
        try {
            RunWithConcurrency.builder().concurrency(this.concurrency).tasks((Iterable)tasks).maxWaitRetries(Integer.MAX_VALUE).waitTime(10L, TimeUnit.MICROSECONDS).terminationFlag(this.terminationFlag).executor(DefaultPool.INSTANCE).mayInterruptIfRunning(false).run();
        }
        finally {
            this.progressTracker.endSubTask();
        }
    }

    private Runnable createBatchRunnable(int relationshipToken, List<Integer> propertyTokens, DegreePartition partition, CompositeRelationshipIterator relationshipIterator, LongUnaryOperator toOriginalId) {
        return () -> this.acceptInTransaction(stmt -> {
            this.terminationFlag.assertRunning();
            Write ops = stmt.dataWrite();
            WriteConsumer writeConsumer = new WriteConsumer(toOriginalId, ops, this.propertyTranslator, relationshipToken, propertyTokens, this.progressTracker);
            partition.consume(nodeId -> relationshipIterator.forEachRelationship(nodeId, (CompositeRelationshipIterator.RelationshipConsumer)writeConsumer));
        });
    }

    private static final class WriteConsumer
    implements CompositeRelationshipIterator.RelationshipConsumer {
        private final LongUnaryOperator toOriginalId;
        private final Write ops;
        private final RelationshipPropertyTranslator propertyTranslator;
        private final int relationshipToken;
        private final List<Integer> propertyTokens;
        private final ProgressTracker progressTracker;
        private final RelationshipWriteBehavior relationshipWriteBehavior;

        private WriteConsumer(LongUnaryOperator toOriginalId, Write ops, RelationshipPropertyTranslator propertyTranslator, int relationshipToken, List<Integer> propertyTokens, ProgressTracker progressTracker) {
            this.toOriginalId = toOriginalId;
            this.ops = ops;
            this.propertyTranslator = propertyTranslator;
            this.relationshipToken = relationshipToken;
            this.propertyTokens = propertyTokens;
            this.progressTracker = progressTracker;
            this.relationshipWriteBehavior = this::write;
        }

        public boolean consume(long sourceNodeId, long targetNodeId, double[] properties) {
            try {
                this.relationshipWriteBehavior.apply(sourceNodeId, targetNodeId, properties);
                return true;
            }
            catch (Exception e) {
                ExceptionUtil.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }

        private void write(long source, long target, double[] properties) throws EntityNotFoundException, ConstraintValidationException {
            long relationshipId = this.ops.relationshipCreate(this.toOriginalId.applyAsLong(source), this.relationshipToken, this.toOriginalId.applyAsLong(target));
            for (int propertyIdx = 0; propertyIdx < properties.length; ++propertyIdx) {
                this.ops.relationshipSetProperty(relationshipId, this.propertyTokens.get(propertyIdx).intValue(), this.propertyTranslator.toValue(properties[propertyIdx]));
            }
            this.progressTracker.logProgress();
        }

        @FunctionalInterface
        static interface RelationshipWriteBehavior {
            public void apply(long var1, long var3, double[] var5) throws EntityNotFoundException, ConstraintValidationException;
        }
    }
}

