/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.LongUnaryOperator;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.LazyBatchCollection;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.write.NativeNodeLabelExporterBuilder;
import org.neo4j.gds.core.write.NodeLabelExporter;
import org.neo4j.gds.core.write.NodeLabelExporterBuilder;
import org.neo4j.gds.termination.TerminationFlag;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.gds.utils.StatementApi;
import org.neo4j.internal.kernel.api.Write;

public class NativeNodeLabelExporter
extends StatementApi
implements NodeLabelExporter {
    private final TerminationFlag terminationFlag;
    private final ExecutorService executorService;
    private final ProgressTracker progressTracker;
    private final int concurrency;
    private final long nodeCount;
    private final LongUnaryOperator toOriginalId;
    private final LongAdder nodeLabelsWritten;

    public static NodeLabelExporterBuilder builder(TransactionContext transactionContext, IdMap idMap, TerminationFlag terminationFlag) {
        return new NativeNodeLabelExporterBuilder(transactionContext).withIdMap(idMap).withTerminationFlag(terminationFlag);
    }

    NativeNodeLabelExporter(TransactionContext tx, long nodeCount, LongUnaryOperator toOriginalId, TerminationFlag terminationFlag, ProgressTracker progressTracker, int concurrency, ExecutorService executorService) {
        super(tx);
        this.nodeCount = nodeCount;
        this.toOriginalId = toOriginalId;
        this.terminationFlag = terminationFlag;
        this.progressTracker = progressTracker;
        this.concurrency = concurrency;
        this.executorService = executorService;
        this.nodeLabelsWritten = new LongAdder();
    }

    @Override
    public void write(String nodeLabel) {
        int nodeLabelToken = this.getOrCreateNodeLabelToken(nodeLabel);
        this.progressTracker.beginSubTask(this.nodeCount);
        try {
            if (this.concurrency > 1 && ParallelUtil.canRunInParallel((ExecutorService)this.executorService)) {
                this.writeParallel(nodeLabelToken);
            } else {
                this.writeSequential(nodeLabelToken);
            }
        }
        finally {
            this.progressTracker.endSubTask();
        }
    }

    @Override
    public long nodeLabelsWritten() {
        return this.nodeLabelsWritten.longValue();
    }

    private void writeSequential(int nodeLabelToken) {
        this.writeSequential((ops, nodeId) -> this.doWrite(ops, nodeId, nodeLabelToken));
    }

    private void writeParallel(int nodeLabelToken) {
        this.writeParallel((ops, offset) -> this.doWrite(ops, offset, nodeLabelToken));
    }

    private void doWrite(Write ops, long nodeId, int nodeLabelToken) throws Exception {
        ops.nodeAddLabel(this.toOriginalId.applyAsLong(nodeId), nodeLabelToken);
        this.nodeLabelsWritten.increment();
    }

    private void writeSequential(WriteConsumer writer) {
        this.acceptInTransaction(stmt -> {
            this.terminationFlag.assertRunning();
            long progress = 0L;
            Write ops = stmt.dataWrite();
            for (long i = 0L; i < this.nodeCount; ++i) {
                writer.accept(ops, i);
                this.progressTracker.logProgress();
                if (++progress % 10000L != 0L) continue;
                this.terminationFlag.assertRunning();
            }
        });
    }

    private void writeParallel(WriteConsumer writer) {
        long batchSize = ParallelUtil.adjustedBatchSize((long)this.nodeCount, (int)this.concurrency, (long)10000L, (long)100000L);
        Collection runnables = LazyBatchCollection.of((long)this.nodeCount, (long)batchSize, (start, len) -> () -> this.acceptInTransaction(stmt -> {
            this.terminationFlag.assertRunning();
            long end = start + len;
            Write ops = stmt.dataWrite();
            for (long currentNode = start; currentNode < end; ++currentNode) {
                writer.accept(ops, currentNode);
                this.progressTracker.logProgress();
                if ((currentNode - start) % 10000L != 0L) continue;
                this.terminationFlag.assertRunning();
            }
        }));
        RunWithConcurrency.builder().concurrency(this.concurrency).tasks((Iterable)runnables).maxWaitRetries(Integer.MAX_VALUE).waitTime(10L, TimeUnit.MICROSECONDS).terminationFlag(this.terminationFlag).executor(this.executorService).mayInterruptIfRunning(false).run();
    }

    public static interface WriteConsumer {
        public void accept(Write var1, long var2) throws Exception;
    }
}

