/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.write.NativeNodePropertyExporter;
import org.neo4j.gds.core.write.NodeProperty;

@Generated(from="NativeNodePropertyExporter.ResolvedNodeProperty", generator="Immutables")
public final class ImmutableResolvedNodeProperty
implements NativeNodePropertyExporter.ResolvedNodeProperty {
    private final String propertyKey;
    private final NodePropertyValues properties;
    private final int propertyToken;

    private ImmutableResolvedNodeProperty(String propertyKey, NodePropertyValues properties, int propertyToken) {
        this.propertyKey = Objects.requireNonNull(propertyKey, "propertyKey");
        this.properties = Objects.requireNonNull(properties, "properties");
        this.propertyToken = propertyToken;
    }

    private ImmutableResolvedNodeProperty(ImmutableResolvedNodeProperty original, String propertyKey, NodePropertyValues properties, int propertyToken) {
        this.propertyKey = propertyKey;
        this.properties = properties;
        this.propertyToken = propertyToken;
    }

    @Override
    public String propertyKey() {
        return this.propertyKey;
    }

    @Override
    public NodePropertyValues properties() {
        return this.properties;
    }

    @Override
    public int propertyToken() {
        return this.propertyToken;
    }

    public final ImmutableResolvedNodeProperty withPropertyKey(String value) {
        String newValue = Objects.requireNonNull(value, "propertyKey");
        if (this.propertyKey.equals(newValue)) {
            return this;
        }
        return new ImmutableResolvedNodeProperty(this, newValue, this.properties, this.propertyToken);
    }

    public final ImmutableResolvedNodeProperty withProperties(NodePropertyValues value) {
        if (this.properties == value) {
            return this;
        }
        NodePropertyValues newValue = Objects.requireNonNull(value, "properties");
        return new ImmutableResolvedNodeProperty(this, this.propertyKey, newValue, this.propertyToken);
    }

    public final ImmutableResolvedNodeProperty withPropertyToken(int value) {
        if (this.propertyToken == value) {
            return this;
        }
        return new ImmutableResolvedNodeProperty(this, this.propertyKey, this.properties, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResolvedNodeProperty && this.equalTo(0, (ImmutableResolvedNodeProperty)another);
    }

    private boolean equalTo(int synthetic, ImmutableResolvedNodeProperty another) {
        return this.propertyKey.equals(another.propertyKey) && this.properties.equals(another.properties) && this.propertyToken == another.propertyToken;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.propertyKey.hashCode();
        h += (h << 5) + this.properties.hashCode();
        h += (h << 5) + this.propertyToken;
        return h;
    }

    public String toString() {
        return "ResolvedNodeProperty{propertyKey=" + this.propertyKey + ", properties=" + this.properties + ", propertyToken=" + this.propertyToken + "}";
    }

    public static NativeNodePropertyExporter.ResolvedNodeProperty of(String propertyKey, NodePropertyValues properties, int propertyToken) {
        return new ImmutableResolvedNodeProperty(propertyKey, properties, propertyToken);
    }

    public static NativeNodePropertyExporter.ResolvedNodeProperty copyOf(NativeNodePropertyExporter.ResolvedNodeProperty instance) {
        if (instance instanceof ImmutableResolvedNodeProperty) {
            return (ImmutableResolvedNodeProperty)instance;
        }
        return ImmutableResolvedNodeProperty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NativeNodePropertyExporter.ResolvedNodeProperty", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PROPERTY_KEY = 1L;
        private static final long INIT_BIT_PROPERTIES = 2L;
        private static final long INIT_BIT_PROPERTY_TOKEN = 4L;
        private long initBits = 7L;
        private String propertyKey;
        private NodePropertyValues properties;
        private int propertyToken;

        private Builder() {
        }

        public final Builder from(NodeProperty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(NativeNodePropertyExporter.ResolvedNodeProperty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            NodeProperty instance;
            long bits = 0L;
            if (object instanceof NodeProperty) {
                instance = (NodeProperty)object;
                if ((bits & 1L) == 0L) {
                    this.propertyKey(instance.propertyKey());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.properties(instance.properties());
                    bits |= 2L;
                }
            }
            if (object instanceof NativeNodePropertyExporter.ResolvedNodeProperty) {
                instance = (NativeNodePropertyExporter.ResolvedNodeProperty)object;
                if ((bits & 1L) == 0L) {
                    this.propertyKey(instance.propertyKey());
                    bits |= 1L;
                }
                this.propertyToken(instance.propertyToken());
                if ((bits & 2L) == 0L) {
                    this.properties(instance.properties());
                    bits |= 2L;
                }
            }
        }

        public final Builder propertyKey(String propertyKey) {
            this.propertyKey = Objects.requireNonNull(propertyKey, "propertyKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder properties(NodePropertyValues properties) {
            this.properties = Objects.requireNonNull(properties, "properties");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder propertyToken(int propertyToken) {
            this.propertyToken = propertyToken;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.propertyKey = null;
            this.properties = null;
            this.propertyToken = 0;
            return this;
        }

        public NativeNodePropertyExporter.ResolvedNodeProperty build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResolvedNodeProperty(null, this.propertyKey, this.properties, this.propertyToken);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("propertyKey");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("properties");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("propertyToken");
            }
            return "Cannot build ResolvedNodeProperty, some of required attributes are not set " + attributes;
        }
    }
}

