/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.write.NodeProperty;

@Generated(from="NodeProperty", generator="Immutables")
public final class ImmutableNodeProperty
implements NodeProperty {
    private final String propertyKey;
    private final NodePropertyValues properties;

    private ImmutableNodeProperty(String propertyKey, NodePropertyValues properties) {
        this.propertyKey = Objects.requireNonNull(propertyKey, "propertyKey");
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    private ImmutableNodeProperty(ImmutableNodeProperty original, String propertyKey, NodePropertyValues properties) {
        this.propertyKey = propertyKey;
        this.properties = properties;
    }

    @Override
    public String propertyKey() {
        return this.propertyKey;
    }

    @Override
    public NodePropertyValues properties() {
        return this.properties;
    }

    public final ImmutableNodeProperty withPropertyKey(String value) {
        String newValue = Objects.requireNonNull(value, "propertyKey");
        if (this.propertyKey.equals(newValue)) {
            return this;
        }
        return new ImmutableNodeProperty(this, newValue, this.properties);
    }

    public final ImmutableNodeProperty withProperties(NodePropertyValues value) {
        if (this.properties == value) {
            return this;
        }
        NodePropertyValues newValue = Objects.requireNonNull(value, "properties");
        return new ImmutableNodeProperty(this, this.propertyKey, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeProperty && this.equalTo(0, (ImmutableNodeProperty)another);
    }

    private boolean equalTo(int synthetic, ImmutableNodeProperty another) {
        return this.propertyKey.equals(another.propertyKey) && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.propertyKey.hashCode();
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return "NodeProperty{propertyKey=" + this.propertyKey + ", properties=" + this.properties + "}";
    }

    public static NodeProperty of(String propertyKey, NodePropertyValues properties) {
        return new ImmutableNodeProperty(propertyKey, properties);
    }

    public static NodeProperty copyOf(NodeProperty instance) {
        if (instance instanceof ImmutableNodeProperty) {
            return (ImmutableNodeProperty)instance;
        }
        return ImmutableNodeProperty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NodeProperty", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PROPERTY_KEY = 1L;
        private static final long INIT_BIT_PROPERTIES = 2L;
        private long initBits = 3L;
        private String propertyKey;
        private NodePropertyValues properties;

        private Builder() {
        }

        public final Builder from(NodeProperty instance) {
            Objects.requireNonNull(instance, "instance");
            this.propertyKey(instance.propertyKey());
            this.properties(instance.properties());
            return this;
        }

        public final Builder propertyKey(String propertyKey) {
            this.propertyKey = Objects.requireNonNull(propertyKey, "propertyKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder properties(NodePropertyValues properties) {
            this.properties = Objects.requireNonNull(properties, "properties");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.propertyKey = null;
            this.properties = null;
            return this;
        }

        public NodeProperty build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeProperty(null, this.propertyKey, this.properties);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("propertyKey");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("properties");
            }
            return "Cannot build NodeProperty, some of required attributes are not set " + attributes;
        }
    }
}

