/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.write.ExporterContext;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;

@Generated(from="ExporterContext", generator="Immutables")
public final class ImmutableExporterContext
implements ExporterContext {
    private final GraphDatabaseService graphDatabaseAPI;
    @Nullable
    private final InternalTransaction internalTransaction;
    private final SecurityContext securityContext;

    private ImmutableExporterContext(GraphDatabaseService graphDatabaseAPI, @Nullable InternalTransaction internalTransaction, SecurityContext securityContext) {
        this.graphDatabaseAPI = Objects.requireNonNull(graphDatabaseAPI, "graphDatabaseAPI");
        this.internalTransaction = internalTransaction;
        this.securityContext = Objects.requireNonNull(securityContext, "securityContext");
    }

    private ImmutableExporterContext(ImmutableExporterContext original, GraphDatabaseService graphDatabaseAPI, @Nullable InternalTransaction internalTransaction, SecurityContext securityContext) {
        this.graphDatabaseAPI = graphDatabaseAPI;
        this.internalTransaction = internalTransaction;
        this.securityContext = securityContext;
    }

    @Override
    public GraphDatabaseService graphDatabaseAPI() {
        return this.graphDatabaseAPI;
    }

    @Override
    @Nullable
    public InternalTransaction internalTransaction() {
        return this.internalTransaction;
    }

    @Override
    public SecurityContext securityContext() {
        return this.securityContext;
    }

    public final ImmutableExporterContext withGraphDatabaseAPI(GraphDatabaseService value) {
        if (this.graphDatabaseAPI == value) {
            return this;
        }
        GraphDatabaseService newValue = Objects.requireNonNull(value, "graphDatabaseAPI");
        return new ImmutableExporterContext(this, newValue, this.internalTransaction, this.securityContext);
    }

    public final ImmutableExporterContext withInternalTransaction(@Nullable InternalTransaction value) {
        if (this.internalTransaction == value) {
            return this;
        }
        return new ImmutableExporterContext(this, this.graphDatabaseAPI, value, this.securityContext);
    }

    public final ImmutableExporterContext withSecurityContext(SecurityContext value) {
        if (this.securityContext == value) {
            return this;
        }
        SecurityContext newValue = Objects.requireNonNull(value, "securityContext");
        return new ImmutableExporterContext(this, this.graphDatabaseAPI, this.internalTransaction, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExporterContext && this.equalTo(0, (ImmutableExporterContext)another);
    }

    private boolean equalTo(int synthetic, ImmutableExporterContext another) {
        return this.graphDatabaseAPI.equals(another.graphDatabaseAPI) && Objects.equals(this.internalTransaction, another.internalTransaction) && this.securityContext.equals(another.securityContext);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.graphDatabaseAPI.hashCode();
        h += (h << 5) + Objects.hashCode(this.internalTransaction);
        h += (h << 5) + this.securityContext.hashCode();
        return h;
    }

    public String toString() {
        return "ExporterContext{graphDatabaseAPI=" + this.graphDatabaseAPI + ", internalTransaction=" + this.internalTransaction + ", securityContext=" + this.securityContext + "}";
    }

    public static ExporterContext of(GraphDatabaseService graphDatabaseAPI, @Nullable InternalTransaction internalTransaction, SecurityContext securityContext) {
        return new ImmutableExporterContext(graphDatabaseAPI, internalTransaction, securityContext);
    }

    public static ExporterContext copyOf(ExporterContext instance) {
        if (instance instanceof ImmutableExporterContext) {
            return (ImmutableExporterContext)instance;
        }
        return ImmutableExporterContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExporterContext", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_GRAPH_DATABASE_A_P_I = 1L;
        private static final long INIT_BIT_SECURITY_CONTEXT = 2L;
        private long initBits = 3L;
        private GraphDatabaseService graphDatabaseAPI;
        private InternalTransaction internalTransaction;
        private SecurityContext securityContext;

        private Builder() {
        }

        public final Builder from(ExporterContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.graphDatabaseAPI(instance.graphDatabaseAPI());
            @Nullable InternalTransaction internalTransactionValue = instance.internalTransaction();
            if (internalTransactionValue != null) {
                this.internalTransaction(internalTransactionValue);
            }
            this.securityContext(instance.securityContext());
            return this;
        }

        public final Builder graphDatabaseAPI(GraphDatabaseService graphDatabaseAPI) {
            this.graphDatabaseAPI = Objects.requireNonNull(graphDatabaseAPI, "graphDatabaseAPI");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder internalTransaction(@Nullable InternalTransaction internalTransaction) {
            this.internalTransaction = internalTransaction;
            return this;
        }

        public final Builder securityContext(SecurityContext securityContext) {
            this.securityContext = Objects.requireNonNull(securityContext, "securityContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.graphDatabaseAPI = null;
            this.internalTransaction = null;
            this.securityContext = null;
            return this;
        }

        public ExporterContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExporterContext(null, this.graphDatabaseAPI, this.internalTransaction, this.securityContext);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("graphDatabaseAPI");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("securityContext");
            }
            return "Cannot build ExporterContext, some of required attributes are not set " + attributes;
        }
    }
}

