/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write;

import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

@ValueClass
public interface ExporterContext {
    public GraphDatabaseService graphDatabaseAPI();

    @Nullable
    public InternalTransaction internalTransaction();

    public SecurityContext securityContext();

    public static final class ProcedureContextWrapper
    implements ExporterContext {
        private final Context procedureContext;

        public ProcedureContextWrapper(Context procedureContext) {
            this.procedureContext = procedureContext;
        }

        public GraphDatabaseAPI graphDatabaseAPI() {
            return this.procedureContext.graphDatabaseAPI();
        }

        @Override
        @Nullable
        public InternalTransaction internalTransaction() {
            return this.procedureContext.internalTransactionOrNull();
        }

        @Override
        public SecurityContext securityContext() {
            return this.procedureContext.securityContext();
        }
    }
}

