/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write;

import org.neo4j.configuration.Config;
import org.neo4j.gds.core.write.ExportBuildersProvider;
import org.neo4j.gds.core.write.ExportBuildersProviderSelector;
import org.neo4j.gds.core.write.ExporterContext;
import org.neo4j.gds.core.write.NodeLabelExporterBuilder;
import org.neo4j.gds.core.write.NodePropertyExporterBuilder;
import org.neo4j.gds.core.write.RelationshipExporterBuilder;
import org.neo4j.gds.core.write.RelationshipPropertiesExporterBuilder;
import org.neo4j.gds.core.write.RelationshipStreamExporterBuilder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public abstract class AbstractExportBuildersExtension
extends ExtensionFactory<Dependencies> {
    protected AbstractExportBuildersExtension() {
        super(ExtensionType.DATABASE, "gds.write-services");
    }

    public Lifecycle newInstance(ExtensionContext context, Dependencies dependencies) {
        ExportBuildersProviderSelector exportBuildersProviderSelector = this.exportBuildersProviderSelector(dependencies.graphDatabaseService(), dependencies.config());
        return new GlobalProceduresExporterComponentProvider(dependencies.globalProcedures(), exportBuildersProviderSelector);
    }

    protected abstract ExportBuildersProviderSelector exportBuildersProviderSelector(GraphDatabaseService var1, Config var2);

    public static interface Dependencies {
        public GlobalProcedures globalProcedures();

        public Config config();

        public GraphDatabaseService graphDatabaseService();
    }

    static class GlobalProceduresExporterComponentProvider
    extends LifecycleAdapter {
        private final GlobalProcedures globalProcedures;
        private final ExportBuildersProviderSelector exportBuildersProviderSelector;

        GlobalProceduresExporterComponentProvider(GlobalProcedures globalProcedures, ExportBuildersProviderSelector exportBuildersProviderSelector) {
            this.globalProcedures = globalProcedures;
            this.exportBuildersProviderSelector = exportBuildersProviderSelector;
        }

        public void init() {
            ExportBuildersProvider exportBuildersProvider = this.exportBuildersProviderSelector.select();
            this.globalProcedures.registerComponent(NodePropertyExporterBuilder.class, ctx -> exportBuildersProvider.nodePropertyExporterBuilder(new ExporterContext.ProcedureContextWrapper((Context)ctx)), true);
            this.globalProcedures.registerComponent(RelationshipStreamExporterBuilder.class, ctx -> exportBuildersProvider.relationshipStreamExporterBuilder(new ExporterContext.ProcedureContextWrapper((Context)ctx)), true);
            this.globalProcedures.registerComponent(RelationshipExporterBuilder.class, ctx -> exportBuildersProvider.relationshipExporterBuilder(new ExporterContext.ProcedureContextWrapper((Context)ctx)), true);
            this.globalProcedures.registerComponent(RelationshipPropertiesExporterBuilder.class, ctx -> exportBuildersProvider.relationshipPropertiesExporterBuilder(new ExporterContext.ProcedureContextWrapper((Context)ctx)), true);
            this.globalProcedures.registerComponent(NodeLabelExporterBuilder.class, ctx -> exportBuildersProvider.nodeLabelExporterBuilder(new ExporterContext.ProcedureContextWrapper((Context)ctx)), true);
        }
    }
}

