/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.applications.algorithms.machinery.MemoryEstimateResult;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.pregel.SpeakerListenerLPAMutateSpecification;
import org.neo4j.gds.pregel.proc.PregelMutateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public final class SpeakerListenerLPAMutateProc
extends BaseProc {
    @Procedure(name="gds.sllpa.mutate", mode=Mode.READ)
    @Description(value="The Speaker Listener Label Propagation algorithm is a fast algorithm for finding overlapping communities in a graph.")
    public Stream<PregelMutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        SpeakerListenerLPAMutateSpecification specification = new SpeakerListenerLPAMutateSpecification();
        ProcedureExecutor executor = new ProcedureExecutor((AlgorithmSpec)specification, this.executionContext());
        return (Stream)executor.compute(graphName, configuration);
    }

    @Procedure(name="gds.sllpa.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        SpeakerListenerLPAMutateSpecification specification = new SpeakerListenerLPAMutateSpecification();
        MemoryEstimationExecutor executor = new MemoryEstimationExecutor((AlgorithmSpec)specification, this.executionContext(), this.transactionContext());
        return executor.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }
}

