/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.stream.Stream;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.logging.Log;
import org.neo4j.gds.pregel.Hits;
import org.neo4j.gds.pregel.HitsAlgorithm;
import org.neo4j.gds.pregel.HitsAlgorithmFactory;
import org.neo4j.gds.pregel.proc.PregelCompanion;
import org.neo4j.gds.pregel.proc.PregelMutateComputationResultConsumer;
import org.neo4j.gds.pregel.proc.PregelMutateResult;
import org.neo4j.gds.procedures.algorithms.configuration.NewConfigFunction;

@GdsCallable(name="gds.hits.mutate", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY, description="Hyperlink-Induced Topic Search (HITS) is a link analysis algorithm that rates nodes")
public final class HitsMutateSpecification
implements AlgorithmSpec<HitsAlgorithm, PregelResult, Hits.HitsConfig, Stream<PregelMutateResult>, HitsAlgorithmFactory> {
    public String name() {
        return HitsAlgorithm.class.getSimpleName();
    }

    public HitsAlgorithmFactory algorithmFactory(ExecutionContext executionContext) {
        return new HitsAlgorithmFactory();
    }

    public NewConfigFunction<Hits.HitsConfig> newConfigFunction() {
        return (__, userInput) -> Hits.HitsConfig.of(userInput);
    }

    public ComputationResultConsumer<HitsAlgorithm, PregelResult, Hits.HitsConfig, Stream<PregelMutateResult>> computationResultConsumer() {
        return new PregelMutateComputationResultConsumer();
    }

    public ValidationConfiguration<Hits.HitsConfig> validationConfig(ExecutionContext executionContext) {
        return PregelCompanion.ensureIndexValidation((Log)executionContext.log(), (TaskRegistryFactory)executionContext.taskRegistryFactory());
    }
}

