/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.beta.pregel.Partitioning;
import org.neo4j.gds.config.ArrowConnectionInfo;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Concurrency;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.pregel.Hits;

public final class HitsConfigImpl
implements Hits.HitsConfig {
    private int hitsIterations;
    private String hubProperty;
    private String authProperty;
    private Partitioning partitioning;
    private String writeProperty;
    private String mutateProperty;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private boolean logProgress;
    private Concurrency concurrency;
    private JobId jobId;
    private Optional<String> relationshipWeightProperty;
    private Concurrency writeConcurrency;
    private Optional<ArrowConnectionInfo> arrowConnectionInfo;
    private boolean writeToResultStore;

    public HitsConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.hitsIterations = config.getInt("hitsIterations", Hits.HitsConfig.super.hitsIterations());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.hubProperty = (String)CypherMapAccess.failOnNull((String)"hubProperty", (Object)Hits.HitsConfig.validateHubProperty(config.getString("hubProperty", Hits.HitsConfig.super.hubProperty())));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.authProperty = (String)CypherMapAccess.failOnNull((String)"authProperty", (Object)Hits.HitsConfig.validateAuthProperty(config.getString("authProperty", Hits.HitsConfig.super.authProperty())));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.partitioning = (Partitioning)CypherMapAccess.failOnNull((String)"partitioning", (Object)Partitioning.parse((Object)config.getChecked("partitioning", (Object)Hits.HitsConfig.super.partitioning(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeProperty = (String)CypherMapAccess.failOnNull((String)"writeProperty", (Object)config.getString("writeProperty", Hits.HitsConfig.super.writeProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.mutateProperty = (String)CypherMapAccess.failOnNull((String)"mutateProperty", (Object)config.getString("mutateProperty", Hits.HitsConfig.super.mutateProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapAccess.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)Hits.HitsConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapAccess.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)Hits.HitsConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapAccess.failOnNull((String)"username", config.getOptional("username", String.class).map(BaseConfig::trim));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", Hits.HitsConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.logProgress = config.getBool("logProgress", Hits.HitsConfig.super.logProgress());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = (Concurrency)CypherMapAccess.failOnNull((String)"concurrency", (Object)ConcurrencyConfig.parse((Object)config.getChecked("concurrency", (Object)Hits.HitsConfig.super.concurrency(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapAccess.failOnNull((String)"jobId", (Object)JobId.parse((Object)config.getChecked("jobId", (Object)Hits.HitsConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = (Optional)CypherMapAccess.failOnNull((String)"relationshipWeightProperty", (Object)config.getOptional("relationshipWeightProperty", String.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeConcurrency = (Concurrency)CypherMapAccess.failOnNull((String)"writeConcurrency", (Object)ConcurrencyConfig.parse((Object)config.getChecked("writeConcurrency", (Object)Hits.HitsConfig.super.writeConcurrency(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.arrowConnectionInfo = (Optional)CypherMapAccess.failOnNull((String)"arrowConnectionInfo", config.getOptional("arrowConnectionInfo", Object.class).map(ArrowConnectionInfo::parse));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeToResultStore = config.getBool("writeToResultStore", Hits.HitsConfig.super.writeToResultStore());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateRelationshipWeightProperty();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateWriteConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public int hitsIterations() {
        return this.hitsIterations;
    }

    @Override
    public String hubProperty() {
        return this.hubProperty;
    }

    @Override
    public String authProperty() {
        return this.authProperty;
    }

    @Override
    public Partitioning partitioning() {
        return this.partitioning;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public String mutateProperty() {
        return this.mutateProperty;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ArrayList<IllegalArgumentException> errors_ = new ArrayList<IllegalArgumentException>();
        try {
            this.validateGraphIsSuitableForWrite(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateNodeLabels(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateRelationshipTypes(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.relationshipWeightValidation(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateMutateProperty(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        if (!errors_.isEmpty()) {
            if (errors_.size() == 1) {
                throw (IllegalArgumentException)errors_.get(0);
            }
            String combinedErrorMsg_ = errors_.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError_ = new IllegalArgumentException(combinedErrorMsg_);
            errors_.forEach(error_ -> combinedError_.addSuppressed((Throwable)error_));
            throw combinedError_;
        }
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public boolean logProgress() {
        return this.logProgress;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("hitsIterations", "hubProperty", "authProperty", "partitioning", "writeProperty", "mutateProperty", "relationshipTypes", "nodeLabels", "username", "sudo", "logProgress", "concurrency", "jobId", "relationshipWeightProperty", "writeConcurrency", "arrowConnectionInfo", "writeToResultStore");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("hitsIterations", this.hitsIterations());
        map.put("hubProperty", this.hubProperty());
        map.put("authProperty", this.authProperty());
        map.put("partitioning", Partitioning.toString((Partitioning)this.partitioning()));
        map.put("writeProperty", this.writeProperty());
        map.put("mutateProperty", this.mutateProperty());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("logProgress", this.logProgress());
        map.put("concurrency", ConcurrencyConfig.render((Concurrency)this.concurrency()));
        map.put("jobId", JobId.asString((JobId)this.jobId()));
        this.relationshipWeightProperty().ifPresent(relationshipWeightProperty -> map.put("relationshipWeightProperty", relationshipWeightProperty));
        map.put("writeConcurrency", ConcurrencyConfig.render((Concurrency)this.writeConcurrency()));
        this.arrowConnectionInfo().ifPresent(arrowConnectionInfo -> map.put("arrowConnectionInfo", ArrowConnectionInfo.toMap((ArrowConnectionInfo)arrowConnectionInfo)));
        map.put("writeToResultStore", this.writeToResultStore());
        return map;
    }

    public Concurrency concurrency() {
        return this.concurrency;
    }

    public JobId jobId() {
        return this.jobId;
    }

    public Optional<String> relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public Concurrency writeConcurrency() {
        return this.writeConcurrency;
    }

    public Optional<ArrowConnectionInfo> arrowConnectionInfo() {
        return this.arrowConnectionInfo;
    }

    public boolean writeToResultStore() {
        return this.writeToResultStore;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(Hits.HitsConfig baseConfig) {
            Builder builder = new Builder();
            builder.hitsIterations(baseConfig.hitsIterations());
            builder.hubProperty(baseConfig.hubProperty());
            builder.authProperty(baseConfig.authProperty());
            builder.partitioning(baseConfig.partitioning());
            builder.writeProperty(baseConfig.writeProperty());
            builder.mutateProperty(baseConfig.mutateProperty());
            builder.relationshipTypes(baseConfig.relationshipTypes());
            builder.nodeLabels(baseConfig.nodeLabels());
            builder.usernameOverride(baseConfig.usernameOverride());
            builder.sudo(baseConfig.sudo());
            builder.logProgress(baseConfig.logProgress());
            builder.concurrency(baseConfig.concurrency());
            builder.jobId(baseConfig.jobId());
            builder.relationshipWeightProperty(baseConfig.relationshipWeightProperty());
            builder.writeConcurrency(baseConfig.writeConcurrency());
            builder.arrowConnectionInfo((Object)baseConfig.arrowConnectionInfo());
            builder.writeToResultStore(baseConfig.writeToResultStore());
            return builder;
        }

        public Builder hitsIterations(int hitsIterations) {
            this.config.put("hitsIterations", hitsIterations);
            return this;
        }

        public Builder hubProperty(String hubProperty) {
            this.config.put("hubProperty", hubProperty);
            return this;
        }

        public Builder authProperty(String authProperty) {
            this.config.put("authProperty", authProperty);
            return this;
        }

        public Builder partitioning(Object partitioning) {
            this.config.put("partitioning", partitioning);
            return this;
        }

        public Builder writeProperty(String writeProperty) {
            this.config.put("writeProperty", writeProperty);
            return this;
        }

        public Builder mutateProperty(String mutateProperty) {
            this.config.put("mutateProperty", mutateProperty);
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder logProgress(boolean logProgress) {
            this.config.put("logProgress", logProgress);
            return this;
        }

        public Builder concurrency(Object concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.config.put("relationshipWeightProperty", relationshipWeightProperty);
            return this;
        }

        public Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            relationshipWeightProperty.ifPresent(actualrelationshipWeightProperty -> this.config.put("relationshipWeightProperty", actualrelationshipWeightProperty));
            return this;
        }

        public Builder writeConcurrency(Object writeConcurrency) {
            this.config.put("writeConcurrency", writeConcurrency);
            return this;
        }

        public Builder arrowConnectionInfo(Object arrowConnectionInfo) {
            this.config.put("arrowConnectionInfo", arrowConnectionInfo);
            return this;
        }

        public Builder arrowConnectionInfo(Optional<Object> arrowConnectionInfo) {
            arrowConnectionInfo.ifPresent(actualarrowConnectionInfo -> this.config.put("arrowConnectionInfo", actualarrowConnectionInfo));
            return this;
        }

        public Builder writeToResultStore(boolean writeToResultStore) {
            this.config.put("writeToResultStore", writeToResultStore);
            return this;
        }

        public Hits.HitsConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new HitsConfigImpl((CypherMapAccess)config);
        }
    }
}

