/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.pregel.HitsStreamSpecification;
import org.neo4j.gds.pregel.proc.PregelStreamResult;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public final class HitsStreamProc
extends BaseProc {
    @Procedure(name="gds.hits.stream", mode=Mode.READ)
    @Description(value="Hyperlink-Induced Topic Search (HITS) is a link analysis algorithm that rates nodes")
    public Stream<PregelStreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        HitsStreamSpecification specification = new HitsStreamSpecification();
        ProcedureExecutor executor = new ProcedureExecutor((AlgorithmSpec)specification, this.executionContext());
        return (Stream)executor.compute(graphName, configuration);
    }

    @Procedure(name="gds.hits.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        HitsStreamSpecification specification = new HitsStreamSpecification();
        MemoryEstimationExecutor executor = new MemoryEstimationExecutor((AlgorithmSpec)specification, this.executionContext(), this.transactionContext());
        return executor.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }
}

