/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.write.NodePropertyExporterBuilder;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.pregel.DeprecatedAlphaHitsWriteSpecification;
import org.neo4j.gds.pregel.proc.PregelWriteResult;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Internal;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public final class DeprecatedAlphaHitsWriteProc
extends BaseProc {
    @Context
    public NodePropertyExporterBuilder nodePropertyExporterBuilder;

    public ExecutionContext executionContext() {
        return super.executionContext().withNodePropertyExporterBuilder(this.nodePropertyExporterBuilder);
    }

    @Internal
    @Deprecated(forRemoval=true)
    @Procedure(name="gds.alpha.hits.write", mode=Mode.WRITE, deprecatedBy="gds.hits.write")
    @Description(value="Hyperlink-Induced Topic Search (HITS) is a link analysis algorithm that rates nodes")
    public Stream<PregelWriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        this.executionContext().metricsFacade().deprecatedProcedures().called("gds.alpha.hits.write");
        DeprecatedAlphaHitsWriteSpecification specification = new DeprecatedAlphaHitsWriteSpecification();
        ProcedureExecutor executor = new ProcedureExecutor((AlgorithmSpec)specification, this.executionContext());
        return (Stream)executor.compute(graphName, configuration);
    }

    @Internal
    @Deprecated(forRemoval=true)
    @Procedure(name="gds.alpha.hits.write.estimate", mode=Mode.READ, deprecatedBy="gds.hits.write.estimate")
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        this.executionContext().metricsFacade().deprecatedProcedures().called("gds.alpha.hits.write.estimate");
        DeprecatedAlphaHitsWriteSpecification specification = new DeprecatedAlphaHitsWriteSpecification();
        MemoryEstimationExecutor executor = new MemoryEstimationExecutor((AlgorithmSpec)specification, this.executionContext(), this.transactionContext());
        return executor.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }
}

