/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.functions;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class OneHotEncodingFunc {
    @UserFunction(value="gds.alpha.ml.oneHotEncoding")
    @Description(value="RETURN gds.alpha.ml.oneHotEncoding(availableValues, selectedValues) - return a list of selected values in a one hot encoding format.")
    public List<Long> oneHotEncoding(@Name(value="availableValues") List<Object> availableValues, @Name(value="selectedValues") List<Object> selectedValues) {
        if (availableValues == null) {
            return LongStream.empty().boxed().collect(Collectors.toList());
        }
        if (selectedValues == null) {
            return LongStream.range(0L, availableValues.size()).map(index -> 0L).boxed().collect(Collectors.toList());
        }
        HashSet<Object> selectedValuesSet = new HashSet<Object>(selectedValues);
        Object[] availableValuesArray = availableValues.toArray();
        return LongStream.range(0L, availableValues.size()).map(index -> selectedValuesSet.contains(availableValuesArray[(int)index]) ? 1L : 0L).boxed().collect(Collectors.toList());
    }
}

