/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.stream.Stream;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.pregel.Hits;
import org.neo4j.gds.pregel.HitsAlgorithm;
import org.neo4j.gds.pregel.HitsAlgorithmFactory;
import org.neo4j.gds.pregel.proc.PregelCompanion;
import org.neo4j.gds.pregel.proc.PregelStreamComputationResultConsumer;
import org.neo4j.gds.pregel.proc.PregelStreamResult;
import org.neo4j.logging.Log;

@GdsCallable(name="gds.hits.stream", executionMode=ExecutionMode.STREAM, description="Hyperlink-Induced Topic Search (HITS) is a link analysis algorithm that rates nodes")
public final class HitsStreamSpecification
implements AlgorithmSpec<HitsAlgorithm, PregelResult, Hits.HitsConfig, Stream<PregelStreamResult>, HitsAlgorithmFactory> {
    public String name() {
        return HitsAlgorithm.class.getSimpleName();
    }

    public HitsAlgorithmFactory algorithmFactory(ExecutionContext executionContext) {
        return new HitsAlgorithmFactory();
    }

    public NewConfigFunction<Hits.HitsConfig> newConfigFunction() {
        return (__, userInput) -> Hits.HitsConfig.of(userInput);
    }

    public ComputationResultConsumer<HitsAlgorithm, PregelResult, Hits.HitsConfig, Stream<PregelStreamResult>> computationResultConsumer() {
        return new PregelStreamComputationResultConsumer();
    }

    public ValidationConfiguration<Hits.HitsConfig> validationConfig(ExecutionContext executionContext) {
        return PregelCompanion.ensureIndexValidation((Log)executionContext.log(), (TaskRegistryFactory)executionContext.taskRegistryFactory());
    }
}

